/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.method.MPJResultType;
import com.github.yulichang.query.MPJQueryWrapper;
import com.github.yulichang.toolkit.MPJReflectionKit;
import com.github.yulichang.toolkit.MPJTableMapperHelper;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.support.FieldCache;
import com.github.yulichang.wrapper.interfaces.SelectWrapper;
import com.github.yulichang.wrapper.resultmap.IResult;
import com.github.yulichang.wrapper.resultmap.Label;
import com.github.yulichang.wrapper.segments.Select;
import com.github.yulichang.wrapper.segments.SelectLabel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MPJInterceptor
implements Interceptor {
    private static final List<ResultMapping> EMPTY_RESULT_MAPPING = new ArrayList<ResultMapping>(0);
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args[0] instanceof MappedStatement) {
            MappedStatement ms = (MappedStatement)args[0];
            if (args[1] instanceof Map) {
                ResultMap resultMap;
                List list;
                Class clazz;
                Object ew;
                Map map = (Map)args[1];
                Object v0 = ew = map.containsKey("ew") ? map.get("ew") : null;
                if (CollectionUtils.isNotEmpty((Map)map) && map.containsKey("resultTypeClass_Eg1sG") && Objects.nonNull(clazz = (Class)map.get("resultTypeClass_Eg1sG")) && CollectionUtils.isNotEmpty((Collection)(list = ms.getResultMaps())) && (resultMap = (ResultMap)list.get(0)).getType() == MPJResultType.class) {
                    args[0] = this.getMappedStatement(ms, clazz, ew);
                }
            }
        }
        return invocation.proceed();
    }

    public MappedStatement getMappedStatement(MappedStatement ms, Class<?> resultType, Object ew) {
        Object wrapper;
        String id = ms.getId() + "-" + resultType.getName().replaceAll("\\.", "-");
        if (ew instanceof SelectWrapper) {
            wrapper = (SelectWrapper)ew;
            if (wrapper.getEntityClass() == null) {
                wrapper.setEntityClass(MPJTableMapperHelper.getEntity(this.getEntity(ms.getId(), ms.getResource())));
            }
            if (wrapper.getSelectColumns().isEmpty() && wrapper.getEntityClass() != null) {
                wrapper.selectAll(wrapper.getEntityClass());
            }
        }
        if (ew instanceof MPJQueryWrapper) {
            wrapper = (MPJQueryWrapper)ew;
            if (ConfigProperties.msCache) {
                return this.getCache(ms, id + "_" + this.removeDot(((MPJQueryWrapper)wrapper).getSqlSelect()), resultType, ew);
            }
        }
        return this.buildMappedStatement(ms, resultType, ew, id);
    }

    private MappedStatement getCache(MappedStatement ms, String id, Class<?> resultType, Object ew) {
        MappedStatement statement;
        Map<Configuration, MappedStatement> statementMap = MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statement = statementMap.get(ms.getConfiguration()))) {
            return statement;
        }
        MappedStatement mappedStatement = this.buildMappedStatement(ms, resultType, ew, id);
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            MS_CACHE.put(id, statementMap);
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }

    private MappedStatement buildMappedStatement(MappedStatement ms, Class<?> resultType, Object ew, String id) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        List<ResultMap> resultMaps = this.buildResultMap(ms, resultType, ew);
        builder.resultMaps(resultMaps);
        return builder.build();
    }

    private List<ResultMap> buildResultMap(MappedStatement ms, Class<?> resultType, Object obj) {
        ArrayList<ResultMap> result = new ArrayList<ResultMap>();
        TableInfo tableInfo = TableHelper.get(resultType);
        String id = ms.getId() + "." + "mybatis-plus" + "_" + resultType.getName();
        if (MPJReflectionKit.isPrimitiveOrWrapper(resultType)) {
            return Collections.singletonList(new ResultMap.Builder(ms.getConfiguration(), id, resultType, EMPTY_RESULT_MAPPING).build());
        }
        if (!(obj instanceof SelectWrapper) || Map.class.isAssignableFrom(resultType) || Collection.class.isAssignableFrom(resultType)) {
            result.add(this.getDefaultResultMap(tableInfo, ms, resultType, id));
            return result;
        }
        SelectWrapper wrapper = (SelectWrapper)obj;
        Map<String, FieldCache> fieldMap = MPJReflectionKit.getFieldMap(resultType);
        List<Select> columnList = wrapper.getSelectColumns();
        columnList.removeIf(Select::isLabel);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        HashSet<String> columnSet = new HashSet<String>();
        for (Select i : columnList) {
            ResultMapping.Builder builder;
            FieldCache field;
            if (i.isHasAlias()) {
                field = fieldMap.get(i.getAlias());
                columnSet.add(i.getAlias());
                if (!Objects.nonNull(field)) continue;
                builder = new ResultMapping.Builder(ms.getConfiguration(), i.getAlias(), i.getAlias(), field.getType());
                resultMappings.add(this.selectToResult(wrapper.getEntityClass(), i, field.getType(), builder));
                continue;
            }
            field = fieldMap.get(i.getColumProperty());
            columnSet.add(i.getTagColumn());
            if (!Objects.nonNull(field)) continue;
            builder = new ResultMapping.Builder(ms.getConfiguration(), i.getColumProperty(), i.getTagColumn(), field.getType());
            resultMappings.add(this.selectToResult(wrapper.getEntityClass(), i, field.getType(), builder));
        }
        if (wrapper.isResultMap()) {
            for (Select o : wrapper.getResultMapMybatisLabel()) {
                Label label = (Label)((Object)o);
                resultMappings.add(this.buildResult(ms, label, columnSet, columnList));
            }
        }
        result.add(new ResultMap.Builder(ms.getConfiguration(), id, resultType, resultMappings).build());
        return result;
    }

    private ResultMapping selectToResult(Class<?> entity, Select select, Class<?> type, ResultMapping.Builder builder) {
        if (select.hasTypeHandle() && select.getTableFieldInfo().getPropertyType().isAssignableFrom(type)) {
            builder.typeHandler(select.getTypeHandle());
        }
        if (select.isPk() && entity == select.getClazz()) {
            builder.flags(Collections.singletonList(ResultFlag.ID));
        }
        return builder.build();
    }

    private ResultMapping buildResult(MappedStatement ms, Label<?> mybatisLabel, Set<String> columnSet, List<Select> columnList) {
        List<IResult> resultList = mybatisLabel.getResultList();
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        StringBuilder childId = new StringBuilder("MPJ_").append(mybatisLabel.getOfType().getName()).append("_").append(mybatisLabel.getProperty()).append("_");
        ArrayList<ResultMapping> childMapping = new ArrayList<ResultMapping>(resultList.size());
        for (IResult r : resultList) {
            SelectLabel label;
            childId.append("(");
            Map<String, FieldCache> ofTypeField = MPJReflectionKit.getFieldMap(mybatisLabel.getOfType());
            String columnName = StringUtils.getTargetColumn((String)r.getSelectNormal().getColumn());
            FieldCache field = ofTypeField.get(r.getProperty());
            String index = r.getIndex();
            if (columnSet.contains(columnName)) {
                columnName = this.getColumn(columnSet, columnName, 0);
                label = new SelectLabel(r.getSelectNormal(), null, mybatisLabel.getOfType(), columnName, StringUtils.isNotBlank((CharSequence)index), index);
            } else {
                columnSet.add(columnName);
                label = new SelectLabel(r.getSelectNormal(), null, mybatisLabel.getOfType(), StringUtils.isNotBlank((CharSequence)index), index);
            }
            columnList.add(label);
            ResultMapping.Builder builder = new ResultMapping.Builder(ms.getConfiguration(), r.getProperty(), columnName, r.getJavaType());
            if (r.isId()) {
                builder.flags(Collections.singletonList(ResultFlag.ID));
                childId.append("i");
            } else {
                childId.append("c");
            }
            if (label.hasTypeHandle() && label.getColumnType().isAssignableFrom(field.getType())) {
                builder.typeHandler(label.getTypeHandle());
            }
            if (Objects.nonNull(r.getJdbcType())) {
                builder.jdbcType(r.getJdbcType());
            }
            childMapping.add(builder.build());
            childId.append("-").append(columnName).append("-").append(r.getProperty()).append(")");
        }
        if (CollectionUtils.isNotEmpty(mybatisLabel.getMybatisLabels())) {
            childId.append("[");
            for (IResult it : mybatisLabel.getMybatisLabels()) {
                ResultMapping result;
                Label o = (Label)((Object)it);
                if (Objects.isNull(o) || Objects.isNull(result = this.buildResult(ms, o, columnSet, columnList))) continue;
                childMapping.add(result);
                childId.append(result.getNestedResultMapId());
                childId.append("@");
            }
            childId.append("]");
        }
        String id = childId.toString();
        if (!ms.getConfiguration().hasResultMap(id)) {
            ResultMap build = new ResultMap.Builder(ms.getConfiguration(), id, mybatisLabel.getOfType(), childMapping).build();
            MPJInterceptor.addResultMap(ms, id, build);
        }
        return new ResultMapping.Builder(ms.getConfiguration(), mybatisLabel.getProperty()).javaType(mybatisLabel.getJavaType()).nestedResultMapId(id).build();
    }

    private String getColumn(Set<String> pool, String columnName, int num) {
        String newName = ConfigProperties.joinPrefix + this.getPrefix(num) + "_" + columnName;
        if (!pool.contains(newName)) {
            pool.add(newName);
            return newName;
        }
        return this.getColumn(pool, columnName, ++num);
    }

    private String getPrefix(int num) {
        String s = Integer.toString(num, 25);
        char[] array = s.toCharArray();
        char[] chars = new char[s.length()];
        for (int i = 0; i < array.length; ++i) {
            chars[i] = (char)(array[i] < ':' ? array[i] + 49 : array[i] + 10);
        }
        return new String(chars);
    }

    private ResultMap getDefaultResultMap(TableInfo tableInfo, MappedStatement ms, Class<?> resultType, String id) {
        if (tableInfo != null && tableInfo.isAutoInitResultMap()) {
            ResultMap resultMap = ms.getConfiguration().getResultMap(tableInfo.getResultMap());
            List resultMappings = resultMap.getResultMappings();
            List fieldList = ReflectionKit.getFieldList(resultType);
            fieldList.removeIf(i -> resultMappings.stream().anyMatch(r -> i.getName().equals(r.getProperty())));
            if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>(resultMappings);
                for (Field i2 : fieldList) {
                    if (!MPJReflectionKit.isPrimitiveOrWrapper(i2.getType())) continue;
                    resultMappingList.add(new ResultMapping.Builder(ms.getConfiguration(), i2.getName(), i2.getName(), i2.getType()).build());
                }
                return new ResultMap.Builder(ms.getConfiguration(), id, resultType, resultMappingList).build();
            }
        }
        return new ResultMap.Builder(ms.getConfiguration(), id, resultType, EMPTY_RESULT_MAPPING).build();
    }

    private static synchronized void addResultMap(MappedStatement ms, String key, ResultMap resultMap) {
        if (!ms.getConfiguration().hasResultMap(key)) {
            ms.getConfiguration().addResultMap(resultMap);
        }
    }

    private Class<?> getEntity(String id, String resource) {
        String className2;
        Class<?> clazz = null;
        try {
            className2 = id.substring(0, id.lastIndexOf("."));
            try {
                clazz = Class.forName(className2);
            }
            catch (ClassNotFoundException e) {
                clazz = MPJTableMapperHelper.getMapperForName(className2);
            }
        }
        catch (Exception className2) {
            // empty catch block
        }
        if (Objects.nonNull(clazz)) {
            return clazz;
        }
        try {
            className2 = resource.substring(0, id.lastIndexOf(".")).replaceAll("/", ".");
            try {
                clazz = Class.forName(className2);
            }
            catch (ClassNotFoundException e) {
                clazz = MPJTableMapperHelper.getMapperForName(className2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private String removeDot(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.replaceAll("\\.", "-");
    }

    public Object plugin(Object target) {
        try {
            return super.plugin(target);
        }
        catch (Exception e) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
    }

    public void setProperties(Properties properties) {
        try {
            super.setProperties(properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

