/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.github.yulichang.annotation.EntityMapping;
import com.github.yulichang.annotation.FieldMapping;
import com.github.yulichang.extension.mapping.config.MappingConfig;
import com.github.yulichang.extension.mapping.mapper.MPJTableFieldInfo;
import com.github.yulichang.extension.mapping.mapper.MPJTableInfo;
import com.github.yulichang.toolkit.MPJReflectionKit;
import com.github.yulichang.toolkit.ReflectionKit;
import com.github.yulichang.toolkit.SpringContentUtils;
import com.github.yulichang.toolkit.TableHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MPJTableInfoHelper {
    private static boolean load = false;
    private static final Map<Class<?>, MPJTableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();

    public static MPJTableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || MPJReflectionKit.isPrimitiveOrWrapper(clazz) || clazz == String.class || clazz.isInterface()) {
            return null;
        }
        MPJTableInfo tableInfo = TABLE_INFO_CACHE.get(clazz);
        if (Objects.nonNull(tableInfo)) {
            return tableInfo;
        }
        if (!load) {
            SpringContentUtils.getBeansOfType(BaseMapper.class);
            MappingConfig.init();
            load = true;
            return MPJTableInfoHelper.getTableInfo(clazz);
        }
        return null;
    }

    public static synchronized void initTableInfo(Class<?> clazz, Class<?> mapperClass) {
        MPJTableInfo info = TABLE_INFO_CACHE.get(clazz);
        if (info != null) {
            return;
        }
        MPJTableInfo mpjTableInfo = new MPJTableInfo();
        mpjTableInfo.setMapperClass(mapperClass);
        mpjTableInfo.setEntityClass(clazz);
        TableInfo tableInfo = TableHelper.get(clazz);
        if (tableInfo == null && mapperClass != null) {
            return;
        }
        mpjTableInfo.setDto(tableInfo == null);
        mpjTableInfo.setTableInfo(tableInfo);
        MPJTableInfoHelper.initMapping(mpjTableInfo);
        TABLE_INFO_CACHE.put(clazz, mpjTableInfo);
    }

    private static boolean isExistMapping(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(EntityMapping.class));
    }

    private static boolean isExistMappingField(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(FieldMapping.class));
    }

    public static void initMapping(MPJTableInfo mpjTableInfo) {
        boolean existMapping = MPJTableInfoHelper.isExistMapping(mpjTableInfo.getEntityClass());
        mpjTableInfo.setHasMapping(existMapping);
        boolean existMappingField = MPJTableInfoHelper.isExistMappingField(mpjTableInfo.getEntityClass());
        mpjTableInfo.setHasMappingField(existMappingField);
        mpjTableInfo.setHasMappingOrField(existMapping || existMappingField);
        ArrayList<MPJTableFieldInfo> mpjFieldList = new ArrayList<MPJTableFieldInfo>();
        List fields = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(mpjTableInfo.getEntityClass()));
        for (Field field : fields) {
            EntityMapping mapping;
            if (existMapping && (mapping = field.getAnnotation(EntityMapping.class)) != null) {
                mpjFieldList.add(new MPJTableFieldInfo(mpjTableInfo.getEntityClass(), mapping, field));
            }
            if (!existMappingField || (mapping = field.getAnnotation(FieldMapping.class)) == null) continue;
            mpjFieldList.add(new MPJTableFieldInfo(mpjTableInfo.getEntityClass(), (FieldMapping)mapping, field));
        }
        mpjTableInfo.setFieldList(mpjFieldList);
    }
}

