/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor;

import com.baomidou.mybatisplus.core.metadata.MPJTableInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfoHelper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.yulichang.method.MPJResultType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MPJInterceptor
implements Interceptor {
    private static final List<ResultMapping> EMPTY_RESULT_MAPPING = new ArrayList<ResultMapping>(0);
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args[0] instanceof MappedStatement) {
            ResultMap resultMap;
            List list;
            Class clazz;
            Map map;
            MappedStatement ms = (MappedStatement)args[0];
            if (args[1] instanceof Map && CollectionUtils.isNotEmpty((Map)(map = (Map)args[1])) && map.containsKey("resultTypeClass_Eg1sG") && Objects.nonNull(clazz = (Class)map.get("resultTypeClass_Eg1sG")) && CollectionUtils.isNotEmpty((Collection)(list = ms.getResultMaps())) && (resultMap = (ResultMap)list.get(0)).getType() == MPJResultType.class) {
                args[0] = this.newMappedStatement(ms, clazz);
            }
        }
        return invocation.proceed();
    }

    public MappedStatement newMappedStatement(MappedStatement ms, Class<?> resultType) {
        MappedStatement statement;
        String id = ms.getId() + "_" + resultType.getName();
        Map<Configuration, MappedStatement> statementMap = MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statement = statementMap.get(ms.getConfiguration()))) {
            return statement;
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(this.newResultMap(ms, resultType));
        builder.resultMaps(resultMaps);
        MappedStatement mappedStatement = builder.build();
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            MS_CACHE.put(id, statementMap);
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }

    private ResultMap newResultMap(MappedStatement ms, Class<?> resultType) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(resultType);
        if (tableInfo != null && tableInfo.isAutoInitResultMap() && tableInfo.getEntityType() == resultType) {
            return ms.getConfiguration().getResultMap(tableInfo.getResultMap());
        }
        MPJTableInfo infoDTO = MPJTableInfoHelper.getTableInfo(resultType);
        if (infoDTO == null) {
            infoDTO = MPJTableInfoHelper.initTableInfo(ms.getConfiguration(), ms.getId().substring(0, ms.getId().lastIndexOf(".")), resultType, null);
        }
        if (infoDTO.getTableInfo().isAutoInitResultMap()) {
            return ms.getConfiguration().getResultMap(infoDTO.getTableInfo().getResultMap());
        }
        return new ResultMap.Builder(ms.getConfiguration(), ms.getId(), resultType, EMPTY_RESULT_MAPPING).build();
    }
}

