/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.annotation.MPJTableAlias;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MPJTableAliasHelper {
    private static final Map<Class<?>, TableAlias> CACHE = new ConcurrentHashMap();
    private static final AtomicInteger index = new AtomicInteger(1);

    public static void init(Class<?> clazz) {
        TableAlias alias = new TableAlias();
        MPJTableAlias tableAlias = clazz.getAnnotation(MPJTableAlias.class);
        if (tableAlias != null && StringUtils.isNotBlank((CharSequence)tableAlias.value())) {
            alias.setAlias(tableAlias.value());
        } else {
            alias.setAlias("t" + index.getAndIncrement());
        }
        alias.setAliasDOT(alias.getAlias() + ".");
        CACHE.put(clazz, alias);
    }

    public static TableAlias get(Class<?> clazz) {
        return CACHE.get(clazz);
    }

    public static class TableAlias {
        private String alias;
        private String aliasDOT;

        public String getAlias() {
            return this.alias;
        }

        public String getAliasDOT() {
            return this.aliasDOT;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setAliasDOT(String aliasDOT) {
            this.aliasDOT = aliasDOT;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableAlias)) {
                return false;
            }
            TableAlias other = (TableAlias)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$aliasDOT = this.getAliasDOT();
            String other$aliasDOT = other.getAliasDOT();
            return !(this$aliasDOT == null ? other$aliasDOT != null : !this$aliasDOT.equals(other$aliasDOT));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableAlias;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $aliasDOT = this.getAliasDOT();
            result = result * 59 + ($aliasDOT == null ? 43 : $aliasDOT.hashCode());
            return result;
        }

        public String toString() {
            return "MPJTableAliasHelper.TableAlias(alias=" + this.getAlias() + ", aliasDOT=" + this.getAliasDOT() + ")";
        }
    }
}

