/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.MPJTableAliasHelper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.enums.BaseFuncEnum;
import com.github.yulichang.wrapper.interfaces.LambdaJoin;
import com.github.yulichang.wrapper.interfaces.Query;
import com.github.yulichang.wrapper.interfaces.on.OnFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements Query<MPJLambdaWrapper<T>>,
LambdaJoin<MPJLambdaWrapper<T>> {
    private final SharedString sqlSelect = new SharedString();
    private final SharedString from = new SharedString();
    private final List<String> selectColumns = new ArrayList<String>();
    private final List<String> ignoreColumns = new ArrayList<String>();
    private final List<String> joinSql = new ArrayList<String>();

    public MPJLambdaWrapper() {
        this.hasAlias = true;
    }

    MPJLambdaWrapper(Class<?> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, boolean hasAlias) {
        this.entityClass = entityClass;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.hasAlias = hasAlias;
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return this.instance(true, null);
    }

    protected MPJLambdaWrapper<T> instance(boolean hasAlias, Class<?> entityClass) {
        return new MPJLambdaWrapper<T>(entityClass, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), hasAlias);
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> select(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.selectColumns.add(this.getThisAlias(s) + this.getCache(s).getColumn());
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <E> MPJLambdaWrapper<T> select(Class<E> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)info, (String)"table can not be find", (Object[])new Object[0]);
        MPJTableAliasHelper.TableAlias alias = MPJTableAliasHelper.get(entityClass);
        info.getFieldList().stream().filter(predicate).collect(Collectors.toList()).forEach(i -> this.selectColumns.add((this.hasAlias ? alias.getAliasDOT() : "") + i.getColumn()));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectAs(SFunction<S, ?> column, String alias) {
        this.selectColumns.add(this.getThisAlias(column) + this.getCache(column).getColumn() + " AS " + alias);
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <S> MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, SFunction<S, ?> column, String alias) {
        if (condition) {
            this.selectColumns.add(String.format(funcEnum.getSql(), this.getThisAlias(column) + this.getCache(column).getColumn()) + " AS " + alias);
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> selectFunc(boolean condition, BaseFuncEnum funcEnum, Object column, String alias) {
        if (condition) {
            this.selectColumns.add(String.format(funcEnum.getSql(), column.toString()) + " AS " + alias);
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public final MPJLambdaWrapper<T> selectAll(Class<?> clazz) {
        String dot;
        TableInfo info = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)info, (String)"table can not be find -> %s", (Object[])new Object[]{clazz});
        String string = dot = this.hasAlias ? MPJTableAliasHelper.get(clazz).getAliasDOT() : "";
        if (info.havePK()) {
            this.selectColumns.add(dot + info.getKeyColumn());
        }
        info.getFieldList().stream().filter(TableFieldInfo::isSelect).forEach(c -> this.selectColumns.add(dot + c.getColumn()));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> selectIgnore(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.ignoreColumns.add(this.getThisAlias(s) + this.getCache(s).getColumn());
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public MPJLambdaWrapper<T> selectQuery(Class<?> clazz, OnFunction function, String alias) {
        MPJLambdaWrapper<?> apply = function.apply(this.instance(false, clazz));
        this.selectColumns.add(String.format("(SELECT %s FROM %s %s)", apply.getSqlSelect(), TableInfoHelper.getTableInfo(clazz).getTableName(), apply.getCustomSqlSegment()) + " AS " + alias);
        return this;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(this.ignoreColumns::contains);
            }
            this.sqlSelect.setStringValue(String.join((CharSequence)",", this.selectColumns));
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            this.from.setStringValue(String.join((CharSequence)" ", this.joinSql));
        }
        return this.from.getStringValue();
    }

    public boolean getAutoAlias() {
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.ignoreColumns.clear();
        this.joinSql.clear();
    }

    @Override
    public <R> MPJLambdaWrapper<T> join(String keyWord, boolean condition, Class<R> clazz, OnFunction function) {
        if (condition) {
            this.joinSql.add(keyWord + TableInfoHelper.getTableInfo(clazz).getTableName() + " " + MPJTableAliasHelper.get(clazz).getAlias() + " ON " + function.apply((MPJLambdaWrapper<?>)this.instance()).getExpression().getNormal().getSqlSegment());
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    private String getThisAlias(SFunction<?, ?> function) {
        return this.hasAlias ? MPJTableAliasHelper.get(LambdaUtils.getEntityClass(function)).getAliasDOT() : "";
    }
}

