/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.Layer;

class PreparedLayer
implements Layer {
    private final Layer layer;
    private final String name;
    private final StateInTarget stateInTarget;

    private PreparedLayer(Layer layer, String name, StateInTarget stateInTarget) {
        this.layer = layer;
        this.name = name;
        this.stateInTarget = stateInTarget;
    }

    String getName() {
        return this.name;
    }

    StateInTarget getStateInTarget() {
        return this.stateInTarget;
    }

    @Override
    public Blob getBlob() {
        return this.layer.getBlob();
    }

    @Override
    public BlobDescriptor getBlobDescriptor() {
        return this.layer.getBlobDescriptor();
    }

    @Override
    public DescriptorDigest getDiffId() {
        return this.layer.getDiffId();
    }

    static class Builder {
        private Layer layer;
        private String name = "unnamed layer";
        private StateInTarget stateInTarget = StateInTarget.UNKNOWN;

        Builder(Layer layer) {
            this.layer = layer;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setStateInTarget(StateInTarget stateInTarget) {
            this.stateInTarget = stateInTarget;
            return this;
        }

        PreparedLayer build() {
            return new PreparedLayer(this.layer, this.name, this.stateInTarget);
        }
    }

    static enum StateInTarget {
        UNKNOWN,
        EXISTING,
        MISSING;

    }
}

