/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;

class CheckManifestStep
implements Callable<Optional<ManifestAndDigest<ManifestTemplate>>> {
    private static final String DESCRIPTION = "Checking existence of manifest";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RegistryClient registryClient;
    private final ManifestTemplate manifestTemplate;

    CheckManifestStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, ManifestTemplate manifestTemplate) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryClient = registryClient;
        this.manifestTemplate = manifestTemplate;
    }

    @Override
    public Optional<ManifestAndDigest<ManifestTemplate>> call() throws IOException, RegistryException {
        DescriptorDigest manifestDigest = Digests.computeJsonDigest(this.manifestTemplate);
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(eventHandlers, DESCRIPTION);){
            ProgressEventDispatcher ignored2;
            block15: {
                ignored2 = this.progressEventDispatcherFactory.create("checking existence of manifest for " + manifestDigest, 1L);
                try {
                    eventHandlers.dispatch(LogEvent.info("Checking existence of manifest for " + manifestDigest + "..."));
                    if (JibSystemProperties.skipExistingImages()) break block15;
                    eventHandlers.dispatch(LogEvent.info("Skipping manifest existence check; system property set to false"));
                    Optional<ManifestAndDigest<ManifestTemplate>> optional = Optional.empty();
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                    return optional;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            Optional<ManifestAndDigest<ManifestTemplate>> optional = this.registryClient.checkManifest(manifestDigest.toString());
            if (ignored2 != null) {
                ignored2.close();
            }
            return optional;
        }
    }
}

