/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.PlatformNotFoundInBaseImageException;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Optional;

public class PlatformChecker {
    private PlatformChecker() {
    }

    static void checkManifestPlatform(BuildContext buildContext, ContainerConfigurationTemplate containerConfig) throws PlatformNotFoundInBaseImageException {
        Optional<Path> path = buildContext.getBaseImageConfiguration().getTarPath();
        String baseImageName = path.map(Path::toString).orElse(buildContext.getBaseImageConfiguration().getImage().toString());
        ImmutableSet<Platform> platforms = buildContext.getContainerConfiguration().getPlatforms();
        Verify.verify((!platforms.isEmpty() ? 1 : 0) != 0);
        if (platforms.size() != 1) {
            String msg = String.format("cannot build for multiple platforms since the base image '%s' is not a manifest list.", baseImageName);
            throw new PlatformNotFoundInBaseImageException(msg);
        }
        Platform platform = (Platform)platforms.iterator().next();
        if (!(platform.getArchitecture().equals(containerConfig.getArchitecture()) && platform.getOs().equals(containerConfig.getOs()) || platform.getArchitecture().equals("amd64") && platform.getOs().equals("linux"))) {
            String msg = String.format("the configured platform (%s/%s) doesn't match the platform (%s/%s) of the base image (%s)", platform.getArchitecture(), platform.getOs(), containerConfig.getArchitecture(), containerConfig.getOs(), baseImageName);
            throw new PlatformNotFoundInBaseImageException(msg);
        }
    }
}

