/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.ModuleNameReader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ModuleFinder {
    protected static final Context.Key<ModuleFinder> moduleFinderKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Names names;
    private final ClassFinder classFinder;
    private final JavaFileManager fileManager;
    private final JCDiagnostic.Factory diags;
    private ModuleNameReader moduleNameReader;
    public ModuleInfoSourceFileCompleter sourceFileCompleter;
    ModuleLocationIterator moduleLocationIterator = new ModuleLocationIterator();
    private boolean inFindSingleModule;

    public static ModuleFinder instance(Context context) {
        ModuleFinder moduleFinder = context.get(moduleFinderKey);
        if (moduleFinder == null) {
            moduleFinder = new ModuleFinder(context);
        }
        return moduleFinder;
    }

    protected ModuleFinder(Context context) {
        context.put(moduleFinderKey, this);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        this.classFinder = ClassFinder.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
    }

    public Symbol.ModuleSymbol findModule(Name name) {
        return this.findModule(this.syms.enterModule(name));
    }

    public Symbol.ModuleSymbol findModule(Symbol.ModuleSymbol moduleSymbol) {
        List<Symbol.ModuleSymbol> list;
        if (moduleSymbol.kind != Kinds.Kind.ERR && moduleSymbol.sourceLocation == null && moduleSymbol.classLocation == null && (list = this.scanModulePath(moduleSymbol)).isEmpty()) {
            moduleSymbol.kind = Kinds.Kind.ERR;
        }
        if (moduleSymbol.kind != Kinds.Kind.ERR && moduleSymbol.module_info.sourcefile == null && moduleSymbol.module_info.classfile == null) {
            this.findModuleInfo(moduleSymbol);
        }
        return moduleSymbol;
    }

    public List<Symbol.ModuleSymbol> findAllModules() {
        List<Symbol.ModuleSymbol> list = this.scanModulePath(null);
        for (Symbol.ModuleSymbol moduleSymbol : list) {
            if (moduleSymbol.kind == Kinds.Kind.ERR || moduleSymbol.module_info.sourcefile != null || moduleSymbol.module_info.classfile != null) continue;
            this.findModuleInfo(moduleSymbol);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol.ModuleSymbol findSingleModule() {
        try {
            Symbol.ModuleSymbol moduleSymbol;
            JavaFileObject javaFileObject;
            JavaFileObject javaFileObject2 = this.getModuleInfoFromLocation(StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE);
            JavaFileObject javaFileObject3 = this.getModuleInfoFromLocation(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
            JavaFileObject javaFileObject4 = javaFileObject2 == null ? javaFileObject3 : (javaFileObject = javaFileObject3 == null ? javaFileObject2 : this.classFinder.preferredFileObject(javaFileObject2, javaFileObject3));
            if (javaFileObject == null) {
                moduleSymbol = this.syms.unnamedModule;
            } else {
                switch (javaFileObject.getKind()) {
                    case SOURCE: {
                        if (!this.inFindSingleModule) {
                            try {
                                this.inFindSingleModule = true;
                                moduleSymbol = this.sourceFileCompleter.complete(javaFileObject);
                                moduleSymbol.module_info.classfile = javaFileObject;
                                break;
                            }
                            finally {
                                this.inFindSingleModule = false;
                            }
                        }
                        moduleSymbol = this.syms.unnamedModule;
                        break;
                    }
                    case CLASS: {
                        Name name;
                        try {
                            name = this.names.fromString(this.readModuleName(javaFileObject));
                        }
                        catch (ModuleNameReader.BadClassFile | IOException exception) {
                            name = this.names.error;
                        }
                        moduleSymbol = this.syms.enterModule(name);
                        moduleSymbol.module_info.classfile = javaFileObject;
                        moduleSymbol.completer = Symbol.Completer.NULL_COMPLETER;
                        this.classFinder.fillIn(moduleSymbol.module_info);
                        break;
                    }
                    default: {
                        Assert.error();
                        moduleSymbol = this.syms.unnamedModule;
                    }
                }
            }
            moduleSymbol.classLocation = StandardLocation.CLASS_OUTPUT;
            return moduleSymbol;
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private String readModuleName(JavaFileObject javaFileObject) throws IOException, ModuleNameReader.BadClassFile {
        if (this.moduleNameReader == null) {
            this.moduleNameReader = new ModuleNameReader();
        }
        return this.moduleNameReader.readModuleName(javaFileObject);
    }

    private JavaFileObject getModuleInfoFromLocation(JavaFileManager.Location location, JavaFileObject.Kind kind) throws IOException {
        if (!this.fileManager.hasLocation(location)) {
            return null;
        }
        return this.fileManager.getJavaFileForInput(location, this.names.module_info.toString(), kind);
    }

    private List<Symbol.ModuleSymbol> scanModulePath(Symbol.ModuleSymbol moduleSymbol) {
        ListBuffer<Symbol.ModuleSymbol> listBuffer = new ListBuffer<Symbol.ModuleSymbol>();
        HashMap<Name, JavaFileManager.Location> hashMap = new HashMap<Name, JavaFileManager.Location>();
        boolean bl = this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH);
        while (this.moduleLocationIterator.hasNext()) {
            Object object = this.moduleLocationIterator.next();
            hashMap.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                JavaFileManager.Location location = (JavaFileManager.Location)iterator.next();
                try {
                    Name name = this.names.fromString(this.fileManager.inferModuleName(location));
                    if (hashMap.put(name, location) == null) {
                        Symbol.ModuleSymbol moduleSymbol2 = this.syms.enterModule(name);
                        if (moduleSymbol2.sourceLocation != null || moduleSymbol2.classLocation != null) continue;
                        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) && moduleSymbol2.patchLocation == null) {
                            moduleSymbol2.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, moduleSymbol2.name.toString());
                            this.checkModuleInfoOnLocation(moduleSymbol2.patchLocation, JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
                            if (moduleSymbol2.patchLocation != null && bl && this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                moduleSymbol2.patchOutputLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, moduleSymbol2.name.toString());
                                this.checkModuleInfoOnLocation(moduleSymbol2.patchOutputLocation, JavaFileObject.Kind.CLASS);
                            }
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.MODULE_SOURCE_PATH) {
                            if (moduleSymbol2.patchLocation == null) {
                                moduleSymbol2.sourceLocation = location;
                                if (this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                    moduleSymbol2.classLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, moduleSymbol2.name.toString());
                                }
                            }
                        } else {
                            moduleSymbol2.classLocation = location;
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.SYSTEM_MODULES || this.moduleLocationIterator.outer == StandardLocation.UPGRADE_MODULE_PATH) {
                            moduleSymbol2.flags_field |= 0x20000000000000L;
                        }
                        if (moduleSymbol != null && (moduleSymbol != moduleSymbol2 || moduleSymbol2.sourceLocation == null && moduleSymbol2.classLocation == null)) continue;
                        listBuffer.add(moduleSymbol2);
                        continue;
                    }
                    this.log.error(CompilerProperties.Errors.DuplicateModuleOnPath(this.getDescription(this.moduleLocationIterator.outer), name));
                }
                catch (IOException iOException) {}
            }
            if (moduleSymbol == null || !listBuffer.nonEmpty()) continue;
            return listBuffer.toList();
        }
        return listBuffer.toList();
    }

    private void checkModuleInfoOnLocation(JavaFileManager.Location location, JavaFileObject.Kind ... kindArray) throws IOException {
        if (location == null) {
            return;
        }
        for (JavaFileObject.Kind kind : kindArray) {
            JavaFileObject javaFileObject = this.fileManager.getJavaFileForInput(location, this.names.module_info.toString(), kind);
            if (javaFileObject == null) continue;
            this.log.error(CompilerProperties.Errors.LocnModuleInfoNotAllowedOnPatchPath(javaFileObject));
            return;
        }
    }

    private void findModuleInfo(final Symbol.ModuleSymbol moduleSymbol) {
        try {
            JavaFileObject javaFileObject;
            JavaFileObject javaFileObject2;
            JavaFileObject javaFileObject3 = moduleSymbol.sourceLocation == null ? null : this.fileManager.getJavaFileForInput(moduleSymbol.sourceLocation, this.names.module_info.toString(), JavaFileObject.Kind.SOURCE);
            JavaFileObject javaFileObject4 = javaFileObject2 = moduleSymbol.classLocation == null ? null : this.fileManager.getJavaFileForInput(moduleSymbol.classLocation, this.names.module_info.toString(), JavaFileObject.Kind.CLASS);
            JavaFileObject javaFileObject5 = javaFileObject3 == null ? javaFileObject2 : (javaFileObject = javaFileObject2 == null ? javaFileObject3 : this.classFinder.preferredFileObject(javaFileObject3, javaFileObject2));
            if (javaFileObject == null) {
                String string;
                String string2 = string = moduleSymbol.sourceLocation == null && moduleSymbol.classLocation != null ? this.fileManager.inferModuleName(moduleSymbol.classLocation) : null;
                if (string != null) {
                    moduleSymbol.module_info.classfile = null;
                    moduleSymbol.flags_field |= 0x10000000000000L;
                } else {
                    moduleSymbol.kind = Kinds.Kind.ERR;
                }
            } else {
                moduleSymbol.module_info.classfile = javaFileObject;
                moduleSymbol.module_info.completer = new Symbol.Completer(){

                    @Override
                    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
                        ModuleFinder.this.classFinder.fillIn(moduleSymbol.module_info);
                    }

                    public String toString() {
                        return "ModuleInfoCompleter";
                    }
                };
            }
        }
        catch (IOException iOException) {
            moduleSymbol.kind = Kinds.Kind.ERR;
        }
    }

    JCDiagnostic.Fragment getDescription(StandardLocation standardLocation) {
        switch (standardLocation) {
            case MODULE_PATH: {
                return CompilerProperties.Fragments.LocnModule_path;
            }
            case MODULE_SOURCE_PATH: {
                return CompilerProperties.Fragments.LocnModule_source_path;
            }
            case SYSTEM_MODULES: {
                return CompilerProperties.Fragments.LocnSystem_modules;
            }
            case UPGRADE_MODULE_PATH: {
                return CompilerProperties.Fragments.LocnUpgrade_module_path;
            }
        }
        throw new AssertionError();
    }

    public static interface ModuleInfoSourceFileCompleter {
        public Symbol.ModuleSymbol complete(JavaFileObject var1);
    }

    class ModuleLocationIterator
    implements Iterator<Set<JavaFileManager.Location>> {
        StandardLocation outer;
        Set<JavaFileManager.Location> next = null;
        Iterator<StandardLocation> outerIter = Arrays.asList(StandardLocation.MODULE_SOURCE_PATH, StandardLocation.UPGRADE_MODULE_PATH, StandardLocation.SYSTEM_MODULES, StandardLocation.MODULE_PATH).iterator();
        Iterator<Set<JavaFileManager.Location>> innerIter = null;

        ModuleLocationIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.innerIter == null || !this.innerIter.hasNext()) {
                    if (this.outerIter.hasNext()) {
                        this.outer = this.outerIter.next();
                        try {
                            this.innerIter = ModuleFinder.this.fileManager.listLocationsForModules(this.outer).iterator();
                        }
                        catch (IOException iOException) {
                            System.err.println("error listing module locations for " + this.outer + ": " + iOException);
                        }
                        continue;
                    }
                    return false;
                }
                if (!this.innerIter.hasNext()) continue;
                this.next = this.innerIter.next();
            }
            return true;
        }

        @Override
        public Set<JavaFileManager.Location> next() {
            this.hasNext();
            if (this.next != null) {
                Set<JavaFileManager.Location> set = this.next;
                this.next = null;
                return set;
            }
            throw new NoSuchElementException();
        }
    }
}

