/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;

public interface JavaFileManager
extends Closeable,
Flushable,
OptionChecker {
    public ClassLoader getClassLoader(Location var1);

    public Iterable<JavaFileObject> list(Location var1, String var2, Set<JavaFileObject.Kind> var3, boolean var4) throws IOException;

    public String inferBinaryName(Location var1, JavaFileObject var2);

    public boolean isSameFile(FileObject var1, FileObject var2);

    public boolean handleOption(String var1, Iterator<String> var2);

    public boolean hasLocation(Location var1);

    public JavaFileObject getJavaFileForInput(Location var1, String var2, JavaFileObject.Kind var3) throws IOException;

    public JavaFileObject getJavaFileForOutput(Location var1, String var2, JavaFileObject.Kind var3, FileObject var4) throws IOException;

    public FileObject getFileForInput(Location var1, String var2, String var3) throws IOException;

    public FileObject getFileForOutput(Location var1, String var2, String var3, FileObject var4) throws IOException;

    @Override
    public void flush() throws IOException;

    @Override
    public void close() throws IOException;

    default public Location getLocationForModule(Location location, String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Location getLocationForModule(Location location, JavaFileObject javaFileObject) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public <S> ServiceLoader<S> getServiceLoader(Location location, Class<S> clazz) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public String inferModuleName(Location location) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Iterable<Set<Location>> listLocationsForModules(Location location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static interface Location {
        public String getName();

        public boolean isOutputLocation();

        default public boolean isModuleOrientedLocation() {
            return this.getName().matches("\\bMODULE\\b");
        }
    }
}

