/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.resolver.java.JavaMigrationResolver;
import com.googlecode.flyway.core.resolver.jdbc.JdbcMigrationResolver;
import com.googlecode.flyway.core.resolver.spring.SpringJdbcMigrationResolver;
import com.googlecode.flyway.core.resolver.sql.SqlMigrationResolver;
import com.googlecode.flyway.core.util.FeatureDetector;
import com.googlecode.flyway.core.util.Location;
import com.googlecode.flyway.core.util.Locations;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMigrationResolver
implements MigrationResolver {
    private final DbSupport dbSupport;
    private final Locations locations;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private List<ResolvedMigration> availableMigrations;

    public CompositeMigrationResolver(DbSupport dbSupport, Locations locations, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix, Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.dbSupport = dbSupport;
        this.locations = locations;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    public List<ResolvedMigration> resolveMigrations() {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations();
        }
        return this.availableMigrations;
    }

    private List<ResolvedMigration> doFindAvailableMigrations() throws FlywayException {
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        for (Location location : this.locations.getLocations()) {
            migrationResolvers.add(new SqlMigrationResolver(this.dbSupport, location, placeholderReplacer, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix));
            migrationResolvers.add(new JdbcMigrationResolver(location));
            if (!FeatureDetector.isSpringJdbcAvailable()) continue;
            migrationResolvers.add(new SpringJdbcMigrationResolver(location));
            migrationResolvers.add(new JavaMigrationResolver(location));
        }
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>(CompositeMigrationResolver.collectMigrations(migrationResolvers));
        Collections.sort(migrations);
        CompositeMigrationResolver.checkForIncompatibilities(migrations);
        return migrations;
    }

    static Collection<ResolvedMigration> collectMigrations(Collection<MigrationResolver> migrationResolvers) {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            migrations.addAll(migrationResolver.resolveMigrations());
        }
        return migrations;
    }

    static void checkForIncompatibilities(List<ResolvedMigration> migrations) {
        for (int i = 0; i < migrations.size() - 1; ++i) {
            ResolvedMigration next;
            ResolvedMigration current = migrations.get(i);
            if (current.compareTo(next = migrations.get(i + 1)) != 0) continue;
            throw new FlywayException(String.format("Found more than one migration with version '%s' (Offenders: %s '%s' and %s '%s')", new Object[]{current.getVersion(), current.getType(), current.getPhysicalLocation(), next.getType(), next.getPhysicalLocation()}));
        }
    }
}

