/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.spring;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.api.migration.MigrationChecksumProvider;
import com.googlecode.flyway.core.api.migration.MigrationInfoProvider;
import com.googlecode.flyway.core.api.migration.spring.SpringJdbcMigration;
import com.googlecode.flyway.core.resolver.MigrationInfoHelper;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.resolver.spring.SpringJdbcMigrationExecutor;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.Location;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.scanner.classpath.ClassPathScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringJdbcMigrationResolver
implements MigrationResolver {
    private final Location location;

    public SpringJdbcMigrationResolver(Location location) {
        this.location = location;
    }

    @Override
    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        if (!this.location.isClassPath()) {
            return migrations;
        }
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new ClassPathScanner().scanForClasses(this.location.getPath(), SpringJdbcMigration.class)) {
                SpringJdbcMigration springJdbcMigration = (SpringJdbcMigration)ClassUtils.instantiate(clazz.getName());
                ResolvedMigration migrationInfo = this.extractMigrationInfo(springJdbcMigration);
                migrationInfo.setPhysicalLocation(ClassUtils.getLocationOnDisk(clazz));
                migrationInfo.setExecutor(new SpringJdbcMigrationExecutor(springJdbcMigration));
                migrations.add(migrationInfo);
            }
        }
        catch (Exception e) {
            throw new FlywayException("Unable to resolve Spring Jdbc Java migrations in location: " + this.location, e);
        }
        Collections.sort(migrations);
        return migrations;
    }

    ResolvedMigration extractMigrationInfo(SpringJdbcMigration springJdbcMigration) {
        String description;
        MigrationVersion version;
        Integer checksum = null;
        if (springJdbcMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)springJdbcMigration);
            checksum = checksumProvider.getChecksum();
        }
        if (springJdbcMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)springJdbcMigration);
            version = infoProvider.getVersion();
            description = infoProvider.getDescription();
            if (!StringUtils.hasText(description)) {
                throw new FlywayException("Missing description for migration " + version);
            }
        } else {
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(ClassUtils.getShortName(springJdbcMigration.getClass()), "V", "");
            version = info.getLeft();
            description = info.getRight();
        }
        String script = springJdbcMigration.getClass().getName();
        ResolvedMigration resolvedMigration = new ResolvedMigration();
        resolvedMigration.setVersion(version);
        resolvedMigration.setDescription(description);
        resolvedMigration.setScript(script);
        resolvedMigration.setChecksum(checksum);
        resolvedMigration.setType(MigrationType.SPRING_JDBC);
        return resolvedMigration;
    }
}

