/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;

public final class FeatureDetector {
    private static final Log LOG = LogFactory.getLog(FeatureDetector.class);
    private static Boolean apacheCommonsLoggingAvailable;
    private static Boolean springJdbcAvailable;
    private static Boolean jbossVFSv2Available;
    private static Boolean jbossVFSv3Available;
    private static Boolean osgiFrameworkAvailable;

    private FeatureDetector() {
    }

    public static boolean isApacheCommonsLoggingAvailable() {
        if (apacheCommonsLoggingAvailable == null) {
            apacheCommonsLoggingAvailable = ClassUtils.isPresent("org.apache.commons.logging.Log");
        }
        return apacheCommonsLoggingAvailable;
    }

    public static boolean isSpringJdbcAvailable() {
        if (springJdbcAvailable == null) {
            springJdbcAvailable = ClassUtils.isPresent("org.springframework.jdbc.core.JdbcTemplate");
            LOG.debug("Spring Jdbc available: " + springJdbcAvailable);
        }
        return springJdbcAvailable;
    }

    public static boolean isJBossVFSv2Available() {
        if (jbossVFSv2Available == null) {
            jbossVFSv2Available = ClassUtils.isPresent("org.jboss.virtual.VFS");
            LOG.debug("JBoss VFS v2 available: " + jbossVFSv2Available);
        }
        return jbossVFSv2Available;
    }

    public static boolean isJBossVFSv3Available() {
        if (jbossVFSv3Available == null) {
            jbossVFSv3Available = ClassUtils.isPresent("org.jboss.vfs.VFS");
            LOG.debug("JBoss VFS v3 available: " + jbossVFSv3Available);
        }
        return jbossVFSv3Available;
    }

    public static boolean isOsgiFrameworkAvailable() {
        if (osgiFrameworkAvailable == null) {
            osgiFrameworkAvailable = ClassUtils.isPresent("org.osgi.framework.Bundle");
            LOG.debug("OSGi framework available: " + osgiFrameworkAvailable);
        }
        return osgiFrameworkAvailable;
    }
}

