/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.collection.trie.datrie.MutableDoubleArrayTrieInteger;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.crfpp.Encoder;
import com.hankcs.hanlp.model.crf.crfpp.FeatureIndex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class DecoderFeatureIndex
extends FeatureIndex {
    private MutableDoubleArrayTrieInteger dat = new MutableDoubleArrayTrieInteger();

    @Override
    public int getID(String key) {
        return this.dat.get(key);
    }

    @Override
    public boolean open(InputStream stream) {
        try {
            ObjectInputStream ois = new ObjectInputStream(stream);
            int version = (Integer)ois.readObject();
            this.costFactor_ = (Double)ois.readObject();
            this.maxid_ = (Integer)ois.readObject();
            this.xsize_ = (Integer)ois.readObject();
            this.y_ = (List)ois.readObject();
            this.unigramTempls_ = (List)ois.readObject();
            this.bigramTempls_ = (List)ois.readObject();
            this.dat = (MutableDoubleArrayTrieInteger)ois.readObject();
            this.alpha_ = (double[])ois.readObject();
            ois.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean convert(String binarymodel, String textmodel) {
        try {
            if (!this.open(IOUtil.newInputStream(binarymodel))) {
                System.err.println("Fail to read binary model " + binarymodel);
                return false;
            }
            OutputStreamWriter osw = new OutputStreamWriter(IOUtil.newOutputStream(textmodel), "UTF-8");
            osw.write("version: " + Encoder.MODEL_VERSION + "\n");
            osw.write("cost-factor: " + this.costFactor_ + "\n");
            osw.write("maxid: " + this.maxid_ + "\n");
            osw.write("xsize: " + this.xsize_ + "\n");
            osw.write("\n");
            for (String y : this.y_) {
                osw.write(y + "\n");
            }
            osw.write("\n");
            for (String utempl : this.unigramTempls_) {
                osw.write(utempl + "\n");
            }
            for (String bitempl : this.bigramTempls_) {
                osw.write(bitempl + "\n");
            }
            osw.write("\n");
            for (MutableDoubleArrayTrieInteger.KeyValuePair pair : this.dat) {
                osw.write(pair.getValue() + " " + pair.getKey() + "\n");
            }
            osw.write("\n");
            for (int k = 0; k < this.maxid_; ++k) {
                String val = new DecimalFormat("0.0000000000000000").format(this.alpha_[k]);
                osw.write(val + "\n");
            }
            osw.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(binarymodel + " does not exist");
            return false;
        }
    }

    public boolean openTextModel(String filename1, boolean cacheBinModel) {
        InputStreamReader isr = null;
        try {
            String line;
            String binFileName = filename1 + ".bin";
            try {
                if (this.open(IOUtil.newInputStream(binFileName))) {
                    System.out.println("Found binary model " + binFileName);
                    return true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            isr = new InputStreamReader(IOUtil.newInputStream(filename1), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            int version = Integer.valueOf(br.readLine().substring("version: ".length()));
            this.costFactor_ = Double.valueOf(br.readLine().substring("cost-factor: ".length()));
            this.maxid_ = Integer.valueOf(br.readLine().substring("maxid: ".length()));
            this.xsize_ = Integer.valueOf(br.readLine().substring("xsize: ".length()));
            System.out.println("Done reading meta-info");
            br.readLine();
            while ((line = br.readLine()) != null && line.length() > 0) {
                this.y_.add(line);
            }
            System.out.println("Done reading labels");
            while ((line = br.readLine()) != null && line.length() > 0) {
                if (line.startsWith("U")) {
                    this.unigramTempls_.add(line);
                    continue;
                }
                if (!line.startsWith("B")) continue;
                this.bigramTempls_.add(line);
            }
            System.out.println("Done reading templates");
            while ((line = br.readLine()) != null && line.length() > 0) {
                String[] content = line.trim().split(" ");
                this.dat.put(content[1], Integer.valueOf(content[0]));
            }
            ArrayList<Double> alpha = new ArrayList<Double>();
            while ((line = br.readLine()) != null && line.length() > 0) {
                alpha.add(Double.valueOf(line));
            }
            System.out.println("Done reading weights");
            this.alpha_ = new double[alpha.size()];
            for (int i = 0; i < alpha.size(); ++i) {
                this.alpha_[i] = (Double)alpha.get(i);
            }
            br.close();
            if (cacheBinModel) {
                System.out.println("Writing binary model to " + binFileName);
                ObjectOutputStream oos = new ObjectOutputStream(IOUtil.newOutputStream(binFileName));
                oos.writeObject(version);
                oos.writeObject(this.costFactor_);
                oos.writeObject(this.maxid_);
                oos.writeObject(this.xsize_);
                oos.writeObject(this.y_);
                oos.writeObject(this.unigramTempls_);
                oos.writeObject(this.bigramTempls_);
                oos.writeObject(this.dat);
                oos.writeObject(this.alpha_);
                oos.close();
            }
        }
        catch (Exception e) {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            System.err.println("Error reading " + filename1);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            return;
        }
        DecoderFeatureIndex featureIndex = new DecoderFeatureIndex();
        if (!featureIndex.convert(args[0], args[1])) {
            System.err.println("fail to convert binary model to text model");
        }
    }
}

