/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureAddress;
import com.hazelcast.azure.AzureAuthenticator;
import com.hazelcast.azure.AzureClient;
import com.hazelcast.azure.AzureComputeApi;
import com.hazelcast.azure.AzureConfig;
import com.hazelcast.azure.AzureMetadataApi;
import com.hazelcast.azure.AzureProperties;
import com.hazelcast.azure.NoCredentialsException;
import com.hazelcast.azure.PortRange;
import com.hazelcast.azure.RestClientException;
import com.hazelcast.azure.Tag;
import com.hazelcast.azure.Utils;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AzureDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AzureDiscoveryStrategy.class);
    private static final int HTTP_FORBIDDEN = 403;
    private final AzureClient azureClient;
    private final PortRange portRange;
    private final Map<String, String> memberMetadata = new HashMap<String, String>();
    private boolean isKnownExceptionAlreadyLogged;

    AzureDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        try {
            AzureConfig azureConfig = this.createAzureConfig();
            AzureMetadataApi azureMetadataApi = new AzureMetadataApi();
            AzureComputeApi azureComputeApi = new AzureComputeApi();
            AzureAuthenticator azureAuthenticator = new AzureAuthenticator();
            this.azureClient = new AzureClient(azureMetadataApi, azureComputeApi, azureAuthenticator, azureConfig);
            this.portRange = azureConfig.getHzPort();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid Azure Discovery Strategy configuration", e);
        }
    }

    AzureDiscoveryStrategy(Map<String, Comparable> properties, AzureClient azureClient) {
        super(LOGGER, properties);
        this.azureClient = azureClient;
        this.portRange = this.createAzureConfig().getHzPort();
    }

    private AzureConfig createAzureConfig() {
        AzureConfig azureConfig = AzureConfig.builder().setTenantId(this.getOrNull(AzureProperties.TENANT_ID)).setClientId(this.getOrNull(AzureProperties.CLIENT_ID)).setClientSecret(this.getOrNull(AzureProperties.CLIENT_SECRET)).setSubscriptionId(this.getOrNull(AzureProperties.SUBSCRIPTION_ID)).setResourceGroup(this.getOrNull(AzureProperties.RESOURCE_GROUP)).setScaleSet(this.getOrNull(AzureProperties.SCALE_SET)).setTag(this.tagOrNull()).setHzPort(new PortRange((String)((Object)this.getOrDefault(AzureProperties.PORT.getDefinition(), AzureProperties.PORT.getDefaultValue())))).setInstanceMetadataAvailable((Boolean)this.getOrDefault(AzureProperties.INSTANCE_METADATA_AVAILABLE.getDefinition(), AzureProperties.INSTANCE_METADATA_AVAILABLE.getDefaultValue())).build();
        this.validate(azureConfig);
        return azureConfig;
    }

    private Tag tagOrNull() {
        String tagString = this.getOrNull(AzureProperties.TAG);
        if (tagString != null) {
            return new Tag(tagString);
        }
        return null;
    }

    private String getOrNull(AzureProperties azureProperties) {
        return (String)this.getOrNull(azureProperties.getDefinition());
    }

    private void validate(AzureConfig azureConfig) {
        if (!azureConfig.isInstanceMetadataAvailable().booleanValue()) {
            LOGGER.info("instance-metadata-available is set to false, validating other properties...");
            if (!Utils.isAllFilled(azureConfig.getTenantId(), azureConfig.getClientId(), azureConfig.getClientSecret(), azureConfig.getSubscriptionId(), azureConfig.getResourceGroup())) {
                throw new InvalidConfigurationException("Invalid Azure Discovery config: useInstanceMetada property is configured as `false`. Please configure all of tenantId, clientId, clientSecret, subscriptionId, and resourceGroup properties.");
            }
        } else if (Utils.isAnyFilled(azureConfig.getTenantId(), azureConfig.getClientId(), azureConfig.getClientSecret(), azureConfig.getSubscriptionId(), azureConfig.getResourceGroup(), azureConfig.getScaleSet())) {
            throw new InvalidConfigurationException("Invalid Azure Discovery config: useInstanceMetada property is configured as `true`. Please DO NOT configure any of tenantId, clientId, clientSecret, subscriptionId, resourceGroup, and scaleSet properties.");
        }
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Collection<AzureAddress> azureAddresses = this.azureClient.getAddresses();
            AzureDiscoveryStrategy.logAzureAddresses(azureAddresses);
            ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
            for (AzureAddress azureAddress : azureAddresses) {
                for (int port = this.portRange.getFromPort(); port <= this.portRange.getToPort(); ++port) {
                    result.add(AzureDiscoveryStrategy.createDiscoveryNode(azureAddress, port));
                }
            }
            return result;
        }
        catch (NoCredentialsException e) {
            if (!this.isKnownExceptionAlreadyLogged) {
                LOGGER.warning("No Azure credentials found! Starting standalone. To use Hazelcast Azure discovery, configure properties (client-id, tenant-id, client-secret) or assign a managed identity to the Azure Compute instance");
                LOGGER.finest(e);
                this.isKnownExceptionAlreadyLogged = true;
            }
        }
        catch (RestClientException e) {
            if (e.getHttpErrorCode() == 403) {
                if (!this.isKnownExceptionAlreadyLogged) {
                    LOGGER.warning("Required role is not assigned to service principal! To use Hazelcast Azure discovery assign a role to service principal with correct 'Read' permissions. Starting standalone.");
                    this.isKnownExceptionAlreadyLogged = true;
                }
                LOGGER.finest(e);
            } else {
                LOGGER.warning("Cannot discover nodes. Starting standalone.", e);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Cannot discover nodes. Starting standalone.", e);
        }
        return Collections.emptyList();
    }

    private static void logAzureAddresses(Collection<AzureAddress> azureAddresses) {
        if (LOGGER.isFinestEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found the following Azure instances: ");
            for (AzureAddress azureAddress : azureAddresses) {
                stringBuilder.append(String.format("%s, ", azureAddress));
            }
            LOGGER.finest(stringBuilder.toString());
        }
    }

    private static DiscoveryNode createDiscoveryNode(AzureAddress azureAddress, int port) throws UnknownHostException {
        Address privateAddress = new Address(azureAddress.getPrivateAddress(), port);
        Address publicAddress = new Address(azureAddress.getPublicAddress(), port);
        return new SimpleDiscoveryNode(privateAddress, publicAddress);
    }

    @Override
    public Map<String, String> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.azureClient.getAvailabilityZone());
        }
        return this.memberMetadata;
    }
}

