/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.RestClientException;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

final class RestClient {
    private static final Logger LOGGER = Logger.getLogger(RestClient.class.getSimpleName());
    private static final int HTTP_OK = 200;
    private final String url;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String body;

    private RestClient(String url) {
        this.url = url;
    }

    static RestClient create(String url) {
        return new RestClient(url);
    }

    private static String read(InputStream stream) {
        if (stream == null) {
            return "";
        }
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    RestClient withHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    RestClient withBody(String body) {
        this.body = body;
        return this;
    }

    String get() {
        return this.call("GET");
    }

    String post() {
        return this.call("POST");
    }

    private String call(String method) {
        HttpURLConnection connection = null;
        FilterOutputStream outputStream = null;
        try {
            URL urlToConnect = new URL(this.url);
            connection = (HttpURLConnection)urlToConnect.openConnection();
            connection.setRequestMethod(method);
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (this.body != null) {
                byte[] bodyData = this.body.getBytes("UTF-8");
                connection.setDoOutput(true);
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(bodyData.length));
                outputStream = new DataOutputStream(connection.getOutputStream());
                outputStream.write(bodyData);
                ((DataOutputStream)outputStream).flush();
            }
            this.checkHttpOk(method, connection);
            String string = RestClient.read(connection.getInputStream());
            return string;
        }
        catch (RestClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestClientException("Failure in executing REST call", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Error while closing HTTP output stream", e);
                }
            }
        }
    }

    private void checkHttpOk(String method, HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() != 200) {
            String errorMessage;
            try {
                errorMessage = RestClient.read(connection.getErrorStream());
            }
            catch (Exception e) {
                throw new RestClientException(String.format("Failure executing: %s at: %s", method, this.url), connection.getResponseCode());
            }
            throw new RestClientException(String.format("Failure executing: %s at: %s. Message: %s", method, this.url, errorMessage), connection.getResponseCode());
        }
    }
}

