/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCachePartitionsIterator;
import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.cache.impl.CacheKeysWithCursor;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;

public class CachePartitionsIterator<K, V>
extends AbstractCachePartitionsIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private final SerializationService serializationService;
    private final CacheProxy<K, V> cacheProxy;

    public CachePartitionsIterator(CacheProxy<K, V> cache, boolean prefetchValues) {
        this(cache, 100, prefetchValues);
    }

    public CachePartitionsIterator(CacheProxy<K, V> cache, int fetchSize, boolean prefetchValues) {
        super(cache, cache.getNodeEngine().getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cache;
        this.serializationService = cache.getNodeEngine().getSerializationService();
        this.advance();
    }

    public CachePartitionsIterator(CacheProxy<K, V> cache, int fetchSize, int partitionId, boolean prefetchValues) {
        super(cache, cache.getNodeEngine().getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cache;
        this.serializationService = cache.getNodeEngine().getSerializationService();
        this.partitionIndex = partitionId;
        this.advance();
    }

    @Override
    protected List fetch() {
        OperationService operationService = this.cacheProxy.getNodeEngine().getOperationService();
        if (this.prefetchValues) {
            Operation operation = this.cacheProxy.operationProvider.createFetchEntriesOperation(this.pointers, this.fetchSize);
            CacheEntriesWithCursor iteratorResult = (CacheEntriesWithCursor)this.invoke(operationService, operation);
            this.setIterationPointers(iteratorResult.getEntries(), iteratorResult.getPointers());
            return iteratorResult.getEntries();
        }
        Operation operation = this.cacheProxy.operationProvider.createFetchKeysOperation(this.pointers, this.fetchSize);
        CacheKeysWithCursor iteratorResult = (CacheKeysWithCursor)this.invoke(operationService, operation);
        this.setIterationPointers(iteratorResult.getKeys(), iteratorResult.getPointers());
        return iteratorResult.getKeys();
    }

    private <T> T invoke(OperationService operationService, Operation operation) {
        InvocationFuture f = operationService.invokeOnPartition("hz:impl:cacheService", operation, this.partitionIndex);
        return (T)((InternalCompletableFuture)f).joinInternal();
    }

    @Override
    protected Data toData(Object obj) {
        return this.serializationService.toData(obj);
    }

    @Override
    protected <T> T toObject(Object data) {
        return this.serializationService.toObject(data);
    }
}

