/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.DeferredValue;
import com.hazelcast.config.AbstractCacheConfig;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheConfigAccessor;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import java.io.IOException;

public class PreJoinCacheConfig<K, V>
extends CacheConfig<K, V> {
    public PreJoinCacheConfig() {
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig) {
        this(cacheConfig, true);
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig, boolean resolved) {
        cacheConfig.copy(this, resolved);
    }

    @Override
    protected void writeKeyValueTypes(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.getKeyClassName());
        out.writeUTF(this.getValueClassName());
    }

    @Override
    protected void readKeyValueTypes(ObjectDataInput in) throws IOException {
        this.setKeyClassName(in.readUTF());
        this.setValueClassName(in.readUTF());
    }

    @Override
    protected void writeTenant(ObjectDataOutput out) throws IOException {
        out.writeObject(CacheConfigAccessor.getTenantControl(this));
    }

    @Override
    protected void readTenant(ObjectDataInput in) throws IOException {
        TenantControl tc = (TenantControl)in.readObject();
        CacheConfigAccessor.setTenantControl(this, tc);
    }

    @Override
    protected void writeFactories(ObjectDataOutput out) throws IOException {
        assert (out instanceof SerializationServiceSupport) : "out must implement SerializationServiceSupport";
        SerializationService serializationService = ((SerializationServiceSupport)((Object)out)).getSerializationService();
        IOUtil.writeData(out, this.cacheLoaderFactory.getSerializedValue(serializationService));
        IOUtil.writeData(out, this.cacheWriterFactory.getSerializedValue(serializationService));
        IOUtil.writeData(out, this.expiryPolicyFactory.getSerializedValue(serializationService));
    }

    @Override
    protected void readFactories(ObjectDataInput in) throws IOException {
        this.cacheLoaderFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
        this.cacheWriterFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
        this.expiryPolicyFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
    }

    @Override
    protected void writeListenerConfigurations(ObjectDataOutput out) throws IOException {
        assert (out instanceof SerializationServiceSupport) : "out must implement SerializationServiceSupport";
        out.writeInt(this.listenerConfigurations.size());
        for (DeferredValue config : this.listenerConfigurations) {
            IOUtil.writeData(out, config.getSerializedValue(((SerializationServiceSupport)((Object)out)).getSerializationService()));
        }
    }

    @Override
    protected void readListenerConfigurations(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.listenerConfigurations = this.createConcurrentSet();
        for (int i = 0; i < size; ++i) {
            DeferredValue serializedConfig = DeferredValue.withSerializedValue(IOUtil.readData(in));
            this.listenerConfigurations.add(serializedConfig);
        }
    }

    @Override
    public int getClassId() {
        return 57;
    }

    CacheConfig asCacheConfig() {
        return this.copy(new CacheConfig(), false);
    }

    @Override
    protected boolean keyValueTypesEqual(AbstractCacheConfig that) {
        if (!this.getKeyClassName().equals(that.getKeyClassName())) {
            return false;
        }
        return this.getValueClassName().equals(that.getValueClassName());
    }

    public static CacheConfig asCacheConfig(CacheConfig cacheConfig) {
        if (!(cacheConfig instanceof PreJoinCacheConfig)) {
            return cacheConfig;
        }
        return ((PreJoinCacheConfig)cacheConfig).asCacheConfig();
    }

    public static PreJoinCacheConfig of(CacheConfig cacheConfig) {
        if (cacheConfig instanceof PreJoinCacheConfig) {
            return (PreJoinCacheConfig)cacheConfig;
        }
        return new PreJoinCacheConfig(cacheConfig, false);
    }
}

