/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.cache.CacheException;
import org.hibernate.internal.util.config.ConfigurationHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private HazelcastInstance client;
    private ClientConfig clientConfig;
    private String instanceName;

    HazelcastClientLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.instanceName = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_instance_name", (Map)props, null);
        if (this.instanceName != null) {
            return;
        }
        String address = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_address", (Map)props, null);
        String clientClusterName = ConfigurationHelper.getString((String)"hibernate.cache.hazelcast.native_client_cluster_name", (Map)props, null);
        String configResourcePath = CacheEnvironment.getConfigFilePath(props);
        if (configResourcePath != null) {
            try {
                this.clientConfig = new XmlClientConfigBuilder(configResourcePath).build();
            }
            catch (IOException e) {
                throw new HazelcastException("Could not load client configuration: " + configResourcePath, e);
            }
        } else {
            this.clientConfig = new ClientConfig();
        }
        if (clientClusterName != null) {
            this.clientConfig.setClusterName(clientClusterName);
        }
        if (address != null) {
            this.clientConfig.getNetworkConfig().addAddress(address);
        }
        this.clientConfig.getNetworkConfig().setSmartRouting(true).setRedoOperation(true);
        this.clientConfig.getConnectionStrategyConfig().setReconnectMode(CacheEnvironment.getFallback(this.toMap(props)) ? ClientConnectionStrategyConfig.ReconnectMode.ASYNC : ClientConnectionStrategyConfig.ReconnectMode.ON).getConnectionRetryConfig().setInitialBackoffMillis((int)CacheEnvironment.getInitialBackoff(props).toMillis()).setMaxBackoffMillis((int)CacheEnvironment.getMaxBackoff(props).toMillis()).setMultiplier(CacheEnvironment.getBackoffMultiplier(props)).setClusterConnectTimeoutMillis(CacheEnvironment.getClusterTimeout(props).toMillis());
    }

    private Map<String, Object> toMap(Properties props) {
        return props.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), Map.Entry::getValue));
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        if (this.instanceName != null) {
            this.client = HazelcastClient.getHazelcastClientByName(this.instanceName);
            if (this.client == null) {
                throw new CacheException("No client with name [" + this.instanceName + "] could be found.");
            }
        } else {
            this.client = HazelcastClient.newHazelcastClient(this.clientConfig);
        }
        return this.client;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.getLifecycleService().shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

