/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ascii;

import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.ascii.MemcacheTextDecoder;
import com.hazelcast.internal.nio.ascii.RestApiTextDecoder;
import com.hazelcast.internal.nio.ascii.TextDecoder;
import com.hazelcast.internal.nio.ascii.TextEncoder;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.AbstractChannelInitializer;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.server.tcp.TextHandshakeDecoder;

public class TextChannelInitializer
extends AbstractChannelInitializer {
    private final boolean rest;

    public TextChannelInitializer(ServerContext serverContext, EndpointConfig config, boolean rest) {
        super(serverContext, config);
        this.rest = rest;
    }

    @Override
    public void initChannel(Channel channel) {
        TcpServerConnection connection = (TcpServerConnection)channel.attributeMap().get(ServerConnection.class);
        TextEncoder encoder = new TextEncoder(connection);
        TextDecoder decoder = this.rest ? new RestApiTextDecoder(connection, encoder, true) : new MemcacheTextDecoder(connection, encoder, true);
        TextHandshakeDecoder handshaker = new TextHandshakeDecoder(this.rest ? ProtocolType.REST : ProtocolType.MEMCACHE, decoder);
        channel.outboundPipeline().addLast(encoder);
        channel.inboundPipeline().addLast(handshaker);
    }
}

