/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractGenericRecord
implements GenericRecord {
    protected abstract Object getClassIdentifier();

    public boolean equals(Object o) {
        Set<String> thisFieldNames;
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGenericRecord)) {
            return false;
        }
        AbstractGenericRecord that = (AbstractGenericRecord)o;
        if (!that.getClassIdentifier().equals(this.getClassIdentifier())) {
            return false;
        }
        Set<String> thatFieldNames = that.getFieldNames();
        if (!Objects.equals(thatFieldNames, thisFieldNames = this.getFieldNames())) {
            return false;
        }
        for (String fieldName : thatFieldNames) {
            FieldType thisFieldType;
            FieldType thatFieldType = that.getFieldType(fieldName);
            if (!thatFieldType.equals((Object)(thisFieldType = this.getFieldType(fieldName)))) {
                return false;
            }
            if (!(thatFieldType.isArrayType() ? !Objects.deepEquals(AbstractGenericRecord.readAny(that, fieldName, thatFieldType), AbstractGenericRecord.readAny(this, fieldName, thisFieldType)) : !Objects.equals(AbstractGenericRecord.readAny(that, fieldName, thatFieldType), AbstractGenericRecord.readAny(this, fieldName, thisFieldType)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Set<String> fieldNames = this.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldType fieldType = this.getFieldType(fieldName);
            if (fieldType.isArrayType()) {
                result = 31 * result + AbstractGenericRecord.arrayHashCode(this, fieldName, fieldType);
                continue;
            }
            result = 31 * result + Objects.hashCode(AbstractGenericRecord.readAny(this, fieldName, fieldType));
        }
        return result;
    }

    private static int arrayHashCode(GenericRecord record, String path, FieldType type) {
        switch (type) {
            case BYTE_ARRAY: {
                return Arrays.hashCode(record.readByteArray(path));
            }
            case SHORT_ARRAY: {
                return Arrays.hashCode(record.readShortArray(path));
            }
            case INT_ARRAY: {
                return Arrays.hashCode(record.readIntArray(path));
            }
            case LONG_ARRAY: {
                return Arrays.hashCode(record.readLongArray(path));
            }
            case FLOAT_ARRAY: {
                return Arrays.hashCode(record.readFloatArray(path));
            }
            case DOUBLE_ARRAY: {
                return Arrays.hashCode(record.readDoubleArray(path));
            }
            case BOOLEAN_ARRAY: {
                return Arrays.hashCode(record.readBooleanArray(path));
            }
            case CHAR_ARRAY: {
                return Arrays.hashCode(record.readCharArray(path));
            }
            case UTF_ARRAY: {
                return Arrays.hashCode(record.readUTFArray(path));
            }
            case PORTABLE_ARRAY: {
                return Arrays.hashCode(record.readGenericRecordArray(path));
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
    }

    private static Object readAny(GenericRecord record, String path, FieldType type) {
        switch (type) {
            case BYTE: {
                return record.readByte(path);
            }
            case BYTE_ARRAY: {
                return record.readByteArray(path);
            }
            case SHORT: {
                return record.readShort(path);
            }
            case SHORT_ARRAY: {
                return record.readShortArray(path);
            }
            case INT: {
                return record.readInt(path);
            }
            case INT_ARRAY: {
                return record.readIntArray(path);
            }
            case LONG: {
                return record.readLong(path);
            }
            case LONG_ARRAY: {
                return record.readLongArray(path);
            }
            case FLOAT: {
                return Float.valueOf(record.readFloat(path));
            }
            case FLOAT_ARRAY: {
                return record.readFloatArray(path);
            }
            case DOUBLE: {
                return record.readDouble(path);
            }
            case DOUBLE_ARRAY: {
                return record.readDoubleArray(path);
            }
            case BOOLEAN: {
                return record.readBoolean(path);
            }
            case BOOLEAN_ARRAY: {
                return record.readBooleanArray(path);
            }
            case CHAR: {
                return Character.valueOf(record.readChar(path));
            }
            case CHAR_ARRAY: {
                return record.readCharArray(path);
            }
            case UTF: {
                return record.readUTF(path);
            }
            case UTF_ARRAY: {
                return record.readUTFArray(path);
            }
            case PORTABLE: {
                return record.readGenericRecord(path);
            }
            case PORTABLE_ARRAY: {
                return record.readGenericRecordArray(path);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClassIdentifier().toString());
        str.append("\n{");
        Set<String> thisFieldNames = this.getFieldNames();
        for (String fieldName : thisFieldNames) {
            block13: {
                Object field;
                block12: {
                    FieldType fieldType = this.getFieldType(fieldName);
                    field = AbstractGenericRecord.readAny(this, fieldName, fieldType);
                    str.append("\"").append(fieldName).append("\" : ");
                    if (!fieldType.isArrayType()) break block12;
                    switch (fieldType) {
                        case BYTE_ARRAY: {
                            str.append(Arrays.toString((byte[])field));
                            break block13;
                        }
                        case SHORT_ARRAY: {
                            str.append(Arrays.toString((short[])field));
                            break block13;
                        }
                        case INT_ARRAY: {
                            str.append(Arrays.toString((int[])field));
                            break block13;
                        }
                        case LONG_ARRAY: {
                            str.append(Arrays.toString((long[])field));
                            break block13;
                        }
                        case FLOAT_ARRAY: {
                            str.append(Arrays.toString((float[])field));
                            break block13;
                        }
                        case DOUBLE_ARRAY: {
                            str.append(Arrays.toString((double[])field));
                            break block13;
                        }
                        case BOOLEAN_ARRAY: {
                            str.append(Arrays.toString((boolean[])field));
                            break block13;
                        }
                        case CHAR_ARRAY: {
                            str.append(Arrays.toString((char[])field));
                            break block13;
                        }
                        case UTF_ARRAY: 
                        case PORTABLE_ARRAY: {
                            str.append(Arrays.toString((Object[])field));
                            break block13;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fieldType));
                        }
                    }
                }
                str.append(field.toString());
            }
            str.append(", \n");
        }
        str.append("}");
        return str.toString();
    }
}

