/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import java.io.IOException;
import java.util.Set;

public class DefaultPortableReader
implements PortableReader {
    protected final ClassDefinition cd;
    protected final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int finalPosition;
    private final int offset;
    private boolean raw;

    DefaultPortableReader(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd) {
        int fieldCount;
        this.in = in;
        this.serializer = serializer;
        this.cd = cd;
        try {
            this.finalPosition = in.readInt();
            fieldCount = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        if (fieldCount != cd.getFieldCount()) {
            throw new IllegalStateException("Field count[" + fieldCount + "] in stream does not match " + cd);
        }
        this.offset = in.position();
    }

    public ClassDefinition getClassDefinition() {
        return this.cd;
    }

    @Override
    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    public FieldType getFieldType(String fieldName) {
        return this.cd.getFieldType(fieldName);
    }

    @Override
    public int getFieldClassId(String fieldName) {
        return this.cd.getFieldClassId(fieldName);
    }

    @Override
    public ObjectDataInput getRawDataInput() throws IOException {
        if (!this.raw) {
            int pos = this.in.readInt(this.offset + this.cd.getFieldCount() * 4);
            this.in.position(pos);
        }
        this.raw = true;
        return this.in;
    }

    final void end() {
        this.in.position(this.finalPosition);
    }

    @Override
    public byte readByte(String fieldName) throws IOException {
        return this.in.readByte(this.readPosition(fieldName, FieldType.BYTE));
    }

    @Override
    public short readShort(String fieldName) throws IOException {
        return this.in.readShort(this.readPosition(fieldName, FieldType.SHORT));
    }

    @Override
    public int readInt(String fieldName) throws IOException {
        return this.in.readInt(this.readPosition(fieldName, FieldType.INT));
    }

    @Override
    public long readLong(String fieldName) throws IOException {
        return this.in.readLong(this.readPosition(fieldName, FieldType.LONG));
    }

    @Override
    public float readFloat(String fieldName) throws IOException {
        return this.in.readFloat(this.readPosition(fieldName, FieldType.FLOAT));
    }

    @Override
    public double readDouble(String fieldName) throws IOException {
        return this.in.readDouble(this.readPosition(fieldName, FieldType.DOUBLE));
    }

    @Override
    public boolean readBoolean(String fieldName) throws IOException {
        return this.in.readBoolean(this.readPosition(fieldName, FieldType.BOOLEAN));
    }

    @Override
    public char readChar(String fieldName) throws IOException {
        return this.in.readChar(this.readPosition(fieldName, FieldType.CHAR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUTF(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF);
            this.in.position(pos);
            String string = this.in.readUTF();
            return string;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portable readPortable(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE) {
                throw new HazelcastSerializationException("Not a Portable field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            if (!isNull) {
                Portable portable = (Portable)this.serializer.readAsObject(this.in, factoryId, classId);
                return portable;
            }
            Portable portable = null;
            return portable;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private boolean isNullOrEmpty(int pos) {
        return pos == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readByteArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                byte[] byArray = null;
                return byArray;
            }
            this.in.position(position);
            byte[] byArray = this.in.readByteArray();
            return byArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] readBooleanArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BOOLEAN_ARRAY);
            if (this.isNullOrEmpty(position)) {
                boolean[] blArray = null;
                return blArray;
            }
            this.in.position(position);
            boolean[] blArray = this.in.readBooleanArray();
            return blArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] readCharArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
            if (this.isNullOrEmpty(position)) {
                char[] cArray = null;
                return cArray;
            }
            this.in.position(position);
            char[] cArray = this.in.readCharArray();
            return cArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] readIntArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.INT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                int[] nArray = null;
                return nArray;
            }
            this.in.position(position);
            int[] nArray = this.in.readIntArray();
            return nArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] readLongArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.LONG_ARRAY);
            if (this.isNullOrEmpty(position)) {
                long[] lArray = null;
                return lArray;
            }
            this.in.position(position);
            long[] lArray = this.in.readLongArray();
            return lArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] readDoubleArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                double[] dArray = null;
                return dArray;
            }
            this.in.position(position);
            double[] dArray = this.in.readDoubleArray();
            return dArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] readFloatArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                float[] fArray = null;
                return fArray;
            }
            this.in.position(position);
            float[] fArray = this.in.readFloatArray();
            return fArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] readShortArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                short[] sArray = null;
                return sArray;
            }
            this.in.position(position);
            short[] sArray = this.in.readShortArray();
            return sArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] readUTFArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.UTF_ARRAY);
            if (this.isNullOrEmpty(position)) {
                String[] stringArray = null;
                return stringArray;
            }
            this.in.position(position);
            String[] stringArray = this.in.readUTFArray();
            return stringArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Portable[] readPortableArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            if (this.isNullOrEmpty(position)) {
                Portable[] portableArray = null;
                return portableArray;
            }
            this.in.position(position);
            int len = this.in.readInt();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            if (len == -1) {
                Portable[] portableArray = null;
                return portableArray;
            }
            this.checkFactoryAndClass(fd, factoryId, classId);
            Portable[] portables = new Portable[len];
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    portables[i] = (Portable)this.serializer.readAsObject(this.in, factoryId, classId);
                }
            }
            Portable[] portableArray = portables;
            return portableArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private void checkFactoryAndClass(FieldDefinition fd, int factoryId, int classId) {
        if (factoryId != fd.getFactoryId()) {
            throw new IllegalArgumentException("Invalid factoryId! Expected: " + fd.getFactoryId() + ", Current: " + factoryId);
        }
        if (classId != fd.getClassId()) {
            throw new IllegalArgumentException("Invalid classId! Expected: " + fd.getClassId() + ", Current: " + classId);
        }
    }

    private int readPosition(String fieldName, FieldType fieldType) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot read Portable fields after getRawDataInput() is called!");
        }
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        if (fd.getType() != fieldType) {
            throw new HazelcastSerializationException("Not a '" + (Object)((Object)fieldType) + "' field: " + fieldName);
        }
        return this.readPosition(fd);
    }

    private HazelcastSerializationException throwUnknownFieldException(String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    private int readPosition(FieldDefinition fd) throws IOException {
        int pos = this.in.readInt(this.offset + fd.getIndex() * 4);
        short len = this.in.readShort(pos);
        return pos + 2 + len + 1;
    }
}

