/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableBatchNestedLoopJoin;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.HashSet;

public class EnumerableBatchNestedLoopJoinRule
extends RelOptRule {
    private final int batchSize;
    private static final int DEFAULT_BATCH_SIZE = 100;

    protected EnumerableBatchNestedLoopJoinRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory, int batchSize) {
        super(EnumerableBatchNestedLoopJoinRule.operand(clazz, EnumerableBatchNestedLoopJoinRule.any()), relBuilderFactory, "EnumerableBatchNestedLoopJoinRule");
        this.batchSize = batchSize;
    }

    public EnumerableBatchNestedLoopJoinRule(RelBuilderFactory relBuilderFactory) {
        this(LogicalJoin.class, relBuilderFactory, 100);
    }

    public EnumerableBatchNestedLoopJoinRule(RelBuilderFactory relBuilderFactory, int batchSize) {
        this(LogicalJoin.class, relBuilderFactory, batchSize);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        JoinRelType joinType = join.getJoinType();
        return joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT || joinType == JoinRelType.ANTI || joinType == JoinRelType.SEMI;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        final int leftFieldCount = join.getLeft().getRowType().getFieldCount();
        RelOptCluster cluster = join.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        HashSet<CorrelationId> correlationIds = new HashSet<CorrelationId>();
        final ArrayList<RexNode> corrVar = new ArrayList<RexNode>();
        for (int i = 0; i < this.batchSize; ++i) {
            CorrelationId correlationId = cluster.createCorrel();
            correlationIds.add(correlationId);
            corrVar.add(rexBuilder.makeCorrel(join.getLeft().getRowType(), correlationId));
        }
        final ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        RexNode condition = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int field = input.getIndex();
                if (field >= leftFieldCount) {
                    return rexBuilder.makeInputRef(input.getType(), input.getIndex() - leftFieldCount);
                }
                requiredColumns.set(field);
                return rexBuilder.makeFieldAccess((RexNode)corrVar.get(0), field);
            }
        });
        ArrayList<RexNode> conditionList = new ArrayList<RexNode>();
        conditionList.add(condition);
        int i = 1;
        while (i < this.batchSize) {
            final int corrIndex = i++;
            RexNode condition2 = condition.accept(new RexShuttle(){

                @Override
                public RexNode visitCorrelVariable(RexCorrelVariable variable) {
                    return (RexNode)corrVar.get(corrIndex);
                }
            });
            conditionList.add(condition2);
        }
        relBuilder.push(join.getRight()).filter(relBuilder.or(conditionList));
        RelNode right = relBuilder.build();
        JoinRelType joinType = join.getJoinType();
        call.transformTo(EnumerableBatchNestedLoopJoin.create(EnumerableBatchNestedLoopJoinRule.convert(join.getLeft(), join.getLeft().getTraitSet().replace(EnumerableConvention.INSTANCE)), EnumerableBatchNestedLoopJoinRule.convert(right, right.getTraitSet().replace(EnumerableConvention.INSTANCE)), join.getCondition(), requiredColumns.build(), correlationIds, joinType));
    }
}

