/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import java.util.Objects;

public class WhileStatement
extends Statement {
    public final Expression condition;
    public final Statement body;

    public WhileStatement(Expression condition, Statement body) {
        super(ExpressionType.While, Void.TYPE);
        assert (condition != null) : "condition should not be null";
        assert (body != null) : "body should not be null";
        this.condition = condition;
        this.body = body;
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression condition1 = this.condition.accept(shuttle);
        Statement body1 = this.body.accept(shuttle);
        return shuttle.visit(this, condition1, body1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("while (").append(this.condition).append(") ").append(Blocks.toBlock(this.body));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WhileStatement that = (WhileStatement)o;
        if (!this.body.equals(that.body)) {
            return false;
        }
        return this.condition.equals(that.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.condition, this.body});
    }
}

