/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;

public class SetopNamespace
extends AbstractNamespace {
    private final SqlCall call;

    protected SetopNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlMonotonicity monotonicity = null;
        int index = this.getRowType().getFieldNames().indexOf(columnName);
        if (index < 0) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        for (SqlNode operand : this.call.getOperandList()) {
            SqlValidatorNamespace namespace = this.validator.getNamespace(operand);
            monotonicity = this.combine(monotonicity, namespace.getMonotonicity(namespace.getRowType().getFieldNames().get(index)));
        }
        return monotonicity;
    }

    private SqlMonotonicity combine(SqlMonotonicity m0, SqlMonotonicity m1) {
        if (m0 == null) {
            return m1;
        }
        if (m1 == null) {
            return m0;
        }
        if (m0 == m1) {
            return m0;
        }
        if (m0.unstrict() == m1) {
            return m1;
        }
        if (m1.unstrict() == m0) {
            return m0;
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        switch (this.call.getKind()) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                SqlValidatorScope scope = this.validator.scopes.get(this.call);
                for (SqlNode operand : this.call.getOperandList()) {
                    if (!operand.isA(SqlKind.QUERY)) {
                        throw this.validator.newValidationError(operand, Static.RESOURCE.needQueryOp(operand.toString()));
                    }
                    this.validator.validateQuery(operand, scope, targetRowType);
                }
                return this.call.getOperator().deriveType(this.validator, scope, this.call);
            }
        }
        throw new AssertionError((Object)("Not a query: " + (Object)((Object)this.call.getKind())));
    }
}

