/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical.visitor;

import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.calcite.SqlToQueryType;
import com.hazelcast.sql.impl.calcite.opt.physical.FilterPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.MapIndexScanPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.MapScanPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ProjectPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.RootPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ValuesPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.exchange.RootExchangePhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.EdgeCollectorPlanNodeVisitor;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.PhysicalRelVisitor;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.PlanFragmentMapping;
import com.hazelcast.sql.impl.plan.cache.PlanCacheKey;
import com.hazelcast.sql.impl.plan.cache.PlanObjectKey;
import com.hazelcast.sql.impl.plan.node.EmptyPlanNode;
import com.hazelcast.sql.impl.plan.node.FilterPlanNode;
import com.hazelcast.sql.impl.plan.node.MapIndexScanPlanNode;
import com.hazelcast.sql.impl.plan.node.MapScanPlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.ProjectPlanNode;
import com.hazelcast.sql.impl.plan.node.RootPlanNode;
import com.hazelcast.sql.impl.plan.node.io.ReceivePlanNode;
import com.hazelcast.sql.impl.plan.node.io.RootSendPlanNode;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PlanCreateVisitor
implements PhysicalRelVisitor {
    private final UUID localMemberId;
    private final Map<UUID, PartitionIdSet> partMap;
    private final Set<UUID> memberIds;
    private final Map<PhysicalRel, List<Integer>> relIdMap;
    private final PlanCacheKey planKey;
    private final List<String> rootColumnNames;
    private final QueryParameterMetadata parameterMetadata;
    private final List<PlanNode> fragments = new ArrayList<PlanNode>();
    private final List<PlanFragmentMapping> fragmentMappings = new ArrayList<PlanFragmentMapping>();
    private final List<Integer> fragmentOutboundEdge = new ArrayList<Integer>();
    private final List<List<Integer>> fragmentInboundEdges = new ArrayList<List<Integer>>();
    private final Deque<PlanNode> upstreamNodes = new ArrayDeque<PlanNode>();
    private int nextEdgeGenerator;
    private RootPhysicalRel rootPhysicalRel;
    private SqlRowMetadata rowMetadata;
    private final Set<PlanObjectKey> objectIds = new HashSet<PlanObjectKey>();
    private final Set<String> mapNames = new HashSet<String>();

    public PlanCreateVisitor(UUID localMemberId, Map<UUID, PartitionIdSet> partMap, Map<PhysicalRel, List<Integer>> relIdMap, PlanCacheKey planKey, List<String> rootColumnNames, QueryParameterMetadata parameterMetadata) {
        this.localMemberId = localMemberId;
        this.partMap = partMap;
        this.relIdMap = relIdMap;
        this.planKey = planKey;
        this.rootColumnNames = rootColumnNames;
        this.parameterMetadata = parameterMetadata;
        this.memberIds = new HashSet<UUID>(partMap.keySet());
    }

    public Plan getPlan() {
        HashMap<Integer, Integer> outboundEdgeMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> inboundEdgeMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> inboundEdgeMemberCountMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.fragments.size(); ++i) {
            PlanFragmentMapping fragmentMapping = this.fragmentMappings.get(i);
            Integer outboundEdge = this.fragmentOutboundEdge.get(i);
            List<Integer> inboundEdges = this.fragmentInboundEdges.get(i);
            if (outboundEdge != null) {
                outboundEdgeMap.put(outboundEdge, i);
            }
            if (inboundEdges == null) continue;
            for (Integer inboundEdge : inboundEdges) {
                int count = fragmentMapping.isDataMembers() ? this.partMap.size() : fragmentMapping.getMemberIds().size();
                inboundEdgeMap.put(inboundEdge, i);
                inboundEdgeMemberCountMap.put(inboundEdge, count);
            }
        }
        assert (this.rootPhysicalRel != null);
        assert (this.rowMetadata != null);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (String mapName : this.mapNames) {
            permissions.add(new MapPermission(mapName, "read"));
        }
        return new Plan(this.partMap, this.fragments, this.fragmentMappings, outboundEdgeMap, inboundEdgeMap, inboundEdgeMemberCountMap, this.rowMetadata, this.parameterMetadata, this.planKey, this.objectIds, permissions);
    }

    @Override
    public void onRoot(RootPhysicalRel rel) {
        this.rootPhysicalRel = rel;
        PlanNode upstreamNode = this.pollSingleUpstream();
        RootPlanNode rootNode = new RootPlanNode(this.pollId(rel), upstreamNode);
        this.rowMetadata = PlanCreateVisitor.createRowMetadata(this.rootColumnNames, rootNode.getSchema().getTypes());
        this.addFragment(rootNode, new PlanFragmentMapping(Collections.singleton(this.localMemberId), false));
    }

    private static SqlRowMetadata createRowMetadata(List<String> columnNames, List<QueryDataType> columnTypes) {
        assert (columnNames.size() == columnTypes.size());
        ArrayList<SqlColumnMetadata> columns = new ArrayList<SqlColumnMetadata>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            SqlColumnMetadata column = QueryUtils.getColumnMetadata(columnNames.get(i), columnTypes.get(i));
            columns.add(column);
        }
        return new SqlRowMetadata(columns);
    }

    @Override
    public void onMapScan(MapScanPhysicalRel rel) {
        AbstractMapTable table = rel.getMap();
        HazelcastTable hazelcastTable = rel.getTableUnwrapped();
        PlanNodeSchema schemaBefore = PlanCreateVisitor.getScanSchemaBeforeProject(table);
        MapScanPlanNode scanNode = new MapScanPlanNode(this.pollId(rel), table.getMapName(), table.getKeyDescriptor(), table.getValueDescriptor(), PlanCreateVisitor.getScanFieldPaths(table), schemaBefore.getTypes(), hazelcastTable.getProjects(), this.convertFilter(schemaBefore, hazelcastTable.getFilter()));
        this.pushUpstream(scanNode);
        this.objectIds.add(table.getObjectKey());
        this.mapNames.add(table.getMapName());
    }

    @Override
    public void onMapIndexScan(MapIndexScanPhysicalRel rel) {
        HazelcastTable hazelcastTable = rel.getTableUnwrapped();
        AbstractMapTable table = rel.getMap();
        PlanNodeSchema schemaBefore = PlanCreateVisitor.getScanSchemaBeforeProject(table);
        MapIndexScanPlanNode scanNode = new MapIndexScanPlanNode(this.pollId(rel), table.getMapName(), table.getKeyDescriptor(), table.getValueDescriptor(), PlanCreateVisitor.getScanFieldPaths(table), schemaBefore.getTypes(), hazelcastTable.getProjects(), rel.getIndex().getName(), rel.getIndex().getComponentsCount(), rel.getIndexFilter(), rel.getConverterTypes(), this.convertFilter(schemaBefore, rel.getRemainderExp()));
        this.pushUpstream(scanNode);
        this.objectIds.add(table.getObjectKey());
        this.mapNames.add(table.getMapName());
    }

    @Override
    public void onRootExchange(RootExchangePhysicalRel rel) {
        PlanNode upstreamNode = this.pollSingleUpstream();
        int edge = this.nextEdge();
        int id = this.pollId(rel);
        RootSendPlanNode sendNode = new RootSendPlanNode(id, upstreamNode, edge);
        this.addFragment(sendNode, this.dataMemberMapping());
        ReceivePlanNode receiveNode = new ReceivePlanNode(id, edge, sendNode.getSchema().getTypes());
        this.pushUpstream(receiveNode);
    }

    @Override
    public void onProject(ProjectPhysicalRel rel) {
        PlanNode upstreamNode = this.pollSingleUpstream();
        List<RexNode> projects = rel.getProjects();
        ArrayList<Expression> convertedProjects = new ArrayList<Expression>(projects.size());
        for (RexNode project : projects) {
            Expression convertedProject = this.convertExpression(upstreamNode.getSchema(), project);
            convertedProjects.add(convertedProject);
        }
        ProjectPlanNode projectNode = new ProjectPlanNode(this.pollId(rel), upstreamNode, convertedProjects);
        this.pushUpstream(projectNode);
    }

    @Override
    public void onFilter(FilterPhysicalRel rel) {
        PlanNode upstreamNode = this.pollSingleUpstream();
        Expression<Boolean> filter = this.convertFilter(upstreamNode.getSchema(), rel.getCondition());
        FilterPlanNode filterNode = new FilterPlanNode(this.pollId(rel), upstreamNode, filter);
        this.pushUpstream(filterNode);
    }

    @Override
    public void onValues(ValuesPhysicalRel rel) {
        if (!rel.getTuples().isEmpty()) {
            throw QueryException.error("Non-empty VALUES are not supported");
        }
        QueryDataType[] fieldTypes = SqlToQueryType.mapRowType(rel.getRowType());
        EmptyPlanNode planNode = new EmptyPlanNode(this.pollId(rel), Arrays.asList(fieldTypes));
        this.pushUpstream(planNode);
    }

    private void pushUpstream(PlanNode node) {
        this.upstreamNodes.addFirst(node);
    }

    private PlanNode pollSingleUpstream() {
        return this.upstreamNodes.pollFirst();
    }

    private void addFragment(PlanNode node, PlanFragmentMapping mapping) {
        EdgeCollectorPlanNodeVisitor edgeVisitor = new EdgeCollectorPlanNodeVisitor();
        node.visit(edgeVisitor);
        this.fragments.add(node);
        this.fragmentMappings.add(mapping);
        this.fragmentOutboundEdge.add(edgeVisitor.getOutboundEdge());
        this.fragmentInboundEdges.add(edgeVisitor.getInboundEdges());
    }

    private int nextEdge() {
        return this.nextEdgeGenerator++;
    }

    private int pollId(PhysicalRel rel) {
        List<Integer> ids = this.relIdMap.get(rel);
        assert (ids != null);
        assert (!ids.isEmpty());
        return ids.remove(0);
    }

    private Expression<Boolean> convertFilter(PlanNodeSchema schema, RexNode expression) {
        if (expression == null) {
            return null;
        }
        Expression convertedExpression = this.convertExpression(schema, expression);
        return convertedExpression;
    }

    private Expression convertExpression(PlanNodeFieldTypeProvider fieldTypeProvider, RexNode expression) {
        if (expression == null) {
            return null;
        }
        RexToExpressionVisitor converter = new RexToExpressionVisitor(fieldTypeProvider, this.parameterMetadata);
        return (Expression)expression.accept(converter);
    }

    private static PlanNodeSchema getScanSchemaBeforeProject(AbstractMapTable table) {
        ArrayList<QueryDataType> types = new ArrayList<QueryDataType>(table.getFieldCount());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            MapTableField field = (MapTableField)table.getField(i);
            types.add(field.getType());
        }
        return new PlanNodeSchema(types);
    }

    private static List<QueryPath> getScanFieldPaths(AbstractMapTable table) {
        ArrayList<QueryPath> res = new ArrayList<QueryPath>(table.getFieldCount());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            MapTableField field = (MapTableField)table.getField(i);
            res.add(field.getPath());
        }
        return res;
    }

    private PlanFragmentMapping dataMemberMapping() {
        return new PlanFragmentMapping(this.memberIds, true);
    }

    private List<Permission> createPermissions() {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (String mapName : this.mapNames) {
            permissions.add(new MapPermission(mapName, "read"));
        }
        permissions.trimToSize();
        return permissions;
    }
}

