/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public abstract class AbstractTemporalConverter
extends Converter {
    protected static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();

    protected AbstractTemporalConverter(int id, QueryDataTypeFamily typeFamily) {
        super(id, typeFamily);
    }

    protected static LocalDateTime dateToTimestamp(LocalDate date) {
        return date.atStartOfDay();
    }

    protected static LocalDateTime timeToTimestamp(LocalTime time) {
        return LocalDateTime.of(LocalDate.now(), time);
    }

    protected static OffsetDateTime timestampToTimestampWithTimezone(LocalDateTime timestamp) {
        return ZonedDateTime.of(timestamp, DEFAULT_ZONE).toOffsetDateTime();
    }

    protected static LocalDateTime timestampWithTimezoneToTimestamp(OffsetDateTime timestampWithTimezone) {
        return timestampWithTimezone.toLocalDateTime();
    }
}

