/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate5CacheKeySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate5CacheKeySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate 5 not available, skipping serializer initialization";
    private final Class<?> cacheKeyClass;

    public Hibernate5CacheKeySerializerHook() {
        Class<?> cacheKeyClass = null;
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            try {
                cacheKeyClass = Class.forName("org.hibernate.cache.internal.OldCacheKeyImplementation");
            }
            catch (Exception e) {
                Logger.getLogger(Hibernate5CacheKeySerializerHook.class).finest(SKIP_INIT_MSG);
            }
        }
        this.cacheKeyClass = cacheKeyClass;
    }

    public Class getSerializationType() {
        return this.cacheKeyClass;
    }

    public Serializer createSerializer() {
        if (this.cacheKeyClass != null) {
            return new Hibernate5CacheKeySerializer();
        }
        return null;
    }

    public boolean isOverwritable() {
        return true;
    }
}

