/*
 * Decompiled with CFR 0.152.
 */
package com.hupubao.dockit.resolver.template;

import com.hupubao.dockit.annotation.Placeholder;
import com.hupubao.dockit.enums.PlaceholderType;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0001J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0016\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/hupubao/dockit/resolver/template/PlaceholderResolver;", "", "()V", "isSimpleType", "", "clazz", "Ljava/lang/Class;", "resolve", "", "node", "Lcom/vladsch/flexmark/ast/Node;", "placeholderList", "", "", "templateValue", "resolveSimpleValue", "placeholderArr", "propertyValue", "resolveTableItem", "tableItem", "tablePlaceholderPrefix", "argument", "undressPlaceholder", "placeholder", "unlinkNodes", "nodesToUnlink", "dockit-maven-plugin"})
public final class PlaceholderResolver {
    public static final PlaceholderResolver INSTANCE;

    private final boolean isSimpleType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        return Intrinsics.areEqual(clazz2, Integer.class) || Intrinsics.areEqual(clazz2, Short.TYPE) || Intrinsics.areEqual(clazz2, Long.TYPE) || Intrinsics.areEqual(clazz2, Double.TYPE) || Intrinsics.areEqual(clazz2, Float.TYPE) || Intrinsics.areEqual(clazz2, Byte.TYPE) || Intrinsics.areEqual(clazz2, Character.TYPE) || Intrinsics.areEqual(clazz2, String.class) || Intrinsics.areEqual(clazz2, Boolean.TYPE);
    }

    private final void resolveSimpleValue(Node node, List<String> placeholderArr, Object propertyValue) {
        for (String placeholder : placeholderArr) {
            String placeholderUndressed = this.undressPlaceholder(placeholder);
            String value = "";
            if (propertyValue != null) {
                CharSequence charSequence = propertyValue.toString();
                String string = charSequence;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (charSequence.length() > 0) {
                    value = propertyValue.toString();
                }
            }
            node.setChars(node.getChars().replace((CharSequence)("${" + placeholderUndressed + '}'), (CharSequence)value));
        }
    }

    public final void resolve(@NotNull Node node, @NotNull List<String> placeholderList, @NotNull Object templateValue) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(placeholderList, (String)"placeholderList");
        Intrinsics.checkParameterIsNotNull((Object)templateValue, (String)"templateValue");
        List nodesToUnlink = new ArrayList();
        if (this.isSimpleType(templateValue.getClass())) {
            this.resolveSimpleValue(node, placeholderList, templateValue);
            return;
        }
        for (KProperty1 property : KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(templateValue.getClass()))) {
            Placeholder annotation;
            String placeholder;
            Object v2;
            block12: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)placeholderList;
                for (Object t : iterable2) {
                    Placeholder annotation2;
                    String placeholder2 = (String)t;
                    Field field = ReflectJvmMapping.getJavaField((KProperty)((KProperty)property));
                    Placeholder placeholder3 = annotation2 = field != null ? field.getAnnotation(Placeholder.class) : null;
                    if (!Intrinsics.areEqual((Object)(placeholder3 != null ? placeholder3.value() : null), (Object)((String)StringsKt.split$default((CharSequence)INSTANCE.undressPlaceholder(placeholder2), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).get(0)))) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            if ((String)v2 == null) {
                continue;
            }
            List placeholderArray = StringsKt.split$default((CharSequence)this.undressPlaceholder(placeholder), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            boolean isCorrectListPlaceholder = placeholderArray.size() > 1;
            Field field = ReflectJvmMapping.getJavaField((KProperty)((KProperty)property));
            if (field == null) {
                Intrinsics.throwNpe();
            }
            if (field.getAnnotation(Placeholder.class) == null) {
                continue;
            }
            Object propertyValue = property.getGetter().call(new Object[]{templateValue});
            if (annotation.type() == PlaceholderType.SIMPLE) {
                this.resolveSimpleValue(node, placeholderArray, propertyValue);
                continue;
            }
            if (annotation.type() != PlaceholderType.LIST) continue;
            if (propertyValue instanceof Iterable) {
                if (node instanceof Paragraph) {
                    Node tableItem = ((Paragraph)node).getLastChild();
                    Iterable $receiver$iv = (Iterable)propertyValue;
                    for (Object element$iv : $receiver$iv) {
                        Object argument = element$iv;
                        if (argument == null) continue;
                        Node node2 = tableItem;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"tableItem");
                        INSTANCE.resolveTableItem(node2, annotation.value(), argument);
                    }
                    if (nodesToUnlink.contains(tableItem)) continue;
                    Node node3 = tableItem;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"tableItem");
                    nodesToUnlink.add(node3);
                    continue;
                }
                Iterable $receiver$iv = (Iterable)propertyValue;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object f = element$iv = iterator.next();
                    BulletList newNode = new BulletList();
                    newNode.setChars(node.getChars());
                    node.insertBefore((Node)newNode);
                    Node node4 = (Node)newNode;
                    List list = isCorrectListPlaceholder ? CollectionsKt.mutableListOf((Object[])new String[]{(String)placeholderArray.get(1)}) : CollectionsKt.mutableListOf((Object[])new String[]{(String)placeholderArray.get(0)});
                    Object object = f;
                    if (object == null) {
                        object = "";
                    }
                    INSTANCE.resolveSimpleValue(node4, list, object);
                }
                if (nodesToUnlink.contains(node)) continue;
                nodesToUnlink.add(node);
                continue;
            }
            this.resolveSimpleValue(node, placeholderArray, propertyValue);
        }
        this.unlinkNodes(nodesToUnlink);
    }

    private final void resolveTableItem(Node tableItem, String tablePlaceholderPrefix, Object argument) {
        Text newText = new Text();
        StringBuilder newTextChars = new StringBuilder((CharSequence)tableItem.getChars().replace((CharSequence)(tablePlaceholderPrefix + '.'), (CharSequence)""));
        CharSequence charSequence = newTextChars;
        BasedSequence basedSequence = BasedSequence.EOL;
        Intrinsics.checkExpressionValueIsNotNull((Object)basedSequence, (String)"BasedSequence.EOL");
        if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)((CharSequence)basedSequence), (boolean)false, (int)2, null)) {
            newTextChars.append("\r\n");
        }
        newText.setChars(SubSequence.of((CharSequence)newTextChars));
        tableItem.insertBefore((Node)newText);
        for (KProperty1 p : KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(argument.getClass()))) {
            Object vau = p.getGetter().call(new Object[]{argument});
            if (vau instanceof Iterable) {
                Iterable $receiver$iv = (Iterable)vau;
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object arg;
                    Object t = arg = (element$iv = iterator.next());
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    INSTANCE.resolveTableItem(tableItem, tablePlaceholderPrefix, t);
                }
                continue;
            }
            this.resolveSimpleValue((Node)newText, CollectionsKt.mutableListOf((Object[])new String[]{p.getName()}), vau);
        }
    }

    private final void unlinkNodes(List<? extends Node> nodesToUnlink) {
        Iterable $receiver$iv = nodesToUnlink;
        for (Object element$iv : $receiver$iv) {
            Node n = (Node)element$iv;
            Node parent = n.getParent();
            n.unlink();
            if (parent == null) continue;
            StringBuilder nodeChars = new StringBuilder();
            ReversiblePeekingIterable reversiblePeekingIterable = parent.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)reversiblePeekingIterable, (String)"parent.children");
            Iterable $receiver$iv2 = (Iterable)reversiblePeekingIterable;
            for (Object element$iv2 : $receiver$iv2) {
                Node child;
                Node node = child = (Node)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
                nodeChars.append((CharSequence)node.getChars());
            }
            parent.setChars(SubSequence.of((CharSequence)nodeChars));
        }
    }

    private final String undressPlaceholder(String placeholder) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)placeholder, (String)"${", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null);
    }

    private PlaceholderResolver() {
    }

    static {
        PlaceholderResolver placeholderResolver;
        INSTANCE = placeholderResolver = new PlaceholderResolver();
    }
}

