/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

abstract class IntColumnFilter
extends ColumnFilter {
    IntColumnFilter() {
    }

    abstract int oneValueToAnother(int var1);

    final Object apply(Object object, JDBCType jDBCType) throws SQLServerException {
        if (object == null) {
            return object;
        }
        switch (jDBCType) {
            case INTEGER: {
                return new Integer(this.oneValueToAnother((Integer)object));
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)this.oneValueToAnother(((Short)object).intValue()));
            }
            case BIGINT: {
                return new Long(this.oneValueToAnother(((Long)object).intValue()));
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return Integer.toString(this.oneValueToAnother(Integer.parseInt((String)object)));
            }
        }
        DataTypes.throwConversionError("int", jDBCType.toString());
        return object;
    }
}

