/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.IntColumnIdentityFilter;
import com.microsoft.sqlserver.jdbc.RowIdLifetime;
import com.microsoft.sqlserver.jdbc.SQLFeatureNotSupportedException;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.ZeroFixupFilter;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLServerDatabaseMetaData
implements DatabaseMetaData,
Serializable {
    private SQLServerConnection connection;
    static final String urlprefix = "jdbc:sqlserver://";
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDatabaseMetaData");
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.DatabaseMetaData");
    private static int baseID = 0;
    private final String traceID;
    EnumMap<CallableHandles, HandleAssociation> handleMap = new EnumMap(CallableHandles.class);
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String ATTR_NAME = "ATTR_NAME";
    private static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String ATTR_SIZE = "ATTR_SIZE";
    private static final String ATTR_DEF = "ATTR_DEF";
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String DEFERRABILITY = "DEFERRABILITY";
    private static final String DELETE_RULE = "DELETE_RULE";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final String FK_NAME = "FK_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String FKTABLE_CAT = "FKTABLE_CAT";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String GRANTEE = "GRANTEE";
    private static final String GRANTOR = "GRANTOR";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String IS_GRANTABLE = "IS_GRANTABLE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String LENGTH = "LENGTH";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String NULLABLE = "NULLABLE";
    private static final String NUM_INPUT_PARAMS = "NUM_INPUT_PARAMS";
    private static final String NUM_OUTPUT_PARAMS = "NUM_OUTPUT_PARAMS";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String NUM_RESULT_SETS = "NUM_RESULT_SETS";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String PAGES = "PAGES";
    private static final String PK_NAME = "PK_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String PKTABLE_CAT = "PKTABLE_CAT";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String PRECISION = "PRECISION";
    private static final String PRIVILEGE = "PRIVILEGE";
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String RADIX = "RADIX";
    private static final String REMARKS = "REMARKS";
    private static final String SCALE = "SCALE";
    private static final String SCOPE = "SCOPE";
    private static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String SS_DATA_TYPE = "SS_DATA_TYPE";
    private static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE = "TYPE";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String UPDATE_RULE = "UPDATE_RULE";
    private static final String FUNCTION_CAT = "FUNCTION_CAT";
    private static final String FUNCTION_NAME = "FUNCTION_NAME";
    private static final String FUNCTION_SCHEM = "FUNCTION_SCHEM";
    private static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    private static final String SS_IS_SPARSE = "SS_IS_SPARSE";
    private static final String SS_IS_COLUMN_SET = "SS_IS_COLUMN_SET";
    private static final String SS_IS_COMPUTED = "SS_IS_COMPUTED";
    private static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    private static final String[] getColumnPrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getTablesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char ESCAPE = '\\';
    static final char PERCENT = '%';
    static final char UNDERSCORE = '_';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    private static final String[] getColumnsColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getColumnsColumnNamesKatmai = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SS_IS_SPARSE", "SS_IS_COLUMN_SET", "SS_IS_COMPUTED", "IS_AUTOINCREMENT"};
    private static final String[] getFunctionsColumnNames = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "FUNCTION_TYPE"};
    private static final String[] getFunctionsColumnsColumnNames = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getBestRowIdentifierColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
    private static final String[] pkfkColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    private static final String[] getIndexInfoColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
    private static final String[] getPrimaryKeysColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
    private static final String[] getProcedureColumnsColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getProceduresColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE"};
    private static final String[] getTablePrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getVersionColumnsColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    public SQLServerDatabaseMetaData(SQLServerConnection sQLServerConnection) {
        this.traceID = " SQLServerDatabaseMetaData:" + SQLServerDatabaseMetaData.nextInstanceID();
        this.connection = sQLServerConnection;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + this.connection.toString() + ")");
        }
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    private void checkClosed() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), "08003", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServerResultSet getResultSetFromInternalQueries(String string, String string2) throws SQLServerException {
        this.checkClosed();
        String string3 = null;
        string3 = this.switchCatalogs(string);
        SQLServerResultSet sQLServerResultSet = null;
        try {
            sQLServerResultSet = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal(string2);
        }
        finally {
            if (null != string3) {
                this.connection.setCatalog(string3);
            }
        }
        return sQLServerResultSet;
    }

    private CallableStatement getCallableStatementHandle(CallableHandles callableHandles, String string) throws SQLServerException {
        HandleAssociation handleAssociation;
        CallableStatement callableStatement = null;
        HandleAssociation handleAssociation2 = this.handleMap.get((Object)callableHandles);
        if (!(null != handleAssociation2 && null != handleAssociation2.databaseName && handleAssociation2.databaseName.equals(string) || null == (handleAssociation = this.handleMap.put(callableHandles, handleAssociation2 = new HandleAssociation(string, callableStatement = callableHandles.prepare(this.connection)))))) {
            handleAssociation.close();
        }
        return handleAssociation2.stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServerResultSet getResultSetFromStoredProc(String string, CallableHandles callableHandles, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        assert (null != stringArray);
        String string2 = null;
        string2 = this.switchCatalogs(string);
        SQLServerResultSet sQLServerResultSet = null;
        try {
            SQLServerCallableStatement sQLServerCallableStatement = (SQLServerCallableStatement)this.getCallableStatementHandle(callableHandles, string);
            for (int i = 1; i <= stringArray.length; ++i) {
                sQLServerCallableStatement.setString(i, stringArray[i - 1]);
            }
            sQLServerResultSet = (SQLServerResultSet)sQLServerCallableStatement.executeQueryInternal();
        }
        finally {
            if (null != string2) {
                this.connection.setCatalog(string2);
            }
        }
        return sQLServerResultSet;
    }

    private final SQLServerResultSet getResultSetWithProvidedColumnNames(String string, CallableHandles callableHandles, String[] stringArray, String[] stringArray2) throws SQLServerException {
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromStoredProc(string, callableHandles, stringArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            sQLServerResultSet.setColumnName(1 + i, stringArray2[i]);
        }
        return sQLServerResultSet;
    }

    private String switchCatalogs(String string) throws SQLServerException {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = null;
        string3 = this.connection.getCatalog().trim();
        if (string3.equals(string2 = string.trim())) {
            return null;
        }
        this.connection.setCatalog(string2);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        return string3;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public ResultSet getCatalogs() throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String string = "SELECT name AS TABLE_CAT FROM sys.databases order by name";
        return this.getResultSetFromInternalQueries(null, string);
    }

    @Override
    public String getCatalogSeparator() throws SQLServerException {
        this.checkClosed();
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLServerException {
        this.checkClosed();
        return "database";
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        string4 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        String[] stringArray = new String[]{string3, string2, string, string4};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_COLUMN_PRIVILEGES, stringArray, getColumnPrivilegesColumnNames);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray2 = new String[4];
        stringArray2[0] = string3;
        stringArray2[1] = string2;
        stringArray2[2] = string;
        String string4 = null;
        if (stringArray != null) {
            string4 = "'";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + "''" + stringArray[i] + "''";
            }
            string4 = string4 + "'";
        }
        stringArray2[3] = string4;
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_TABLES, stringArray2, getTablesColumnNames);
    }

    private static String EscapeIDName(String string) throws SQLServerException {
        if (null == string) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\\' == c && ++i < string.length()) {
                c = string.charAt(i);
                switch (c) {
                    case '%': 
                    case '[': 
                    case '_': {
                        stringBuilder.append('[');
                        stringBuilder.append(c);
                        stringBuilder.append(']');
                        break;
                    }
                    case '\\': 
                    case ']': {
                        stringBuilder.append(c);
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String string5 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray = this.connection.isKatmaiOrLater() ? new String[6] : new String[5];
        stringArray[0] = string3;
        stringArray[1] = string2;
        stringArray[2] = string;
        stringArray[3] = string5;
        if (this.connection.isKatmaiOrLater()) {
            stringArray[4] = "2";
            stringArray[5] = "3";
        } else {
            stringArray[4] = "3";
        }
        SQLServerResultSet sQLServerResultSet = this.connection.isKatmaiOrLater() ? this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_COLUMNS, stringArray, getColumnsColumnNamesKatmai) : this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_COLUMNS, stringArray, getColumnsColumnNames);
        sQLServerResultSet.getColumn(5).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            sQLServerResultSet.getColumn(22).setFilter(new IntColumnIdentityFilter());
            sQLServerResultSet.getColumn(7).setFilter(new ZeroFixupFilter());
            sQLServerResultSet.getColumn(8).setFilter(new ZeroFixupFilter());
            sQLServerResultSet.getColumn(16).setFilter(new ZeroFixupFilter());
        }
        return sQLServerResultSet;
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        Object object;
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        if (string != null && string.length() == 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            Object[] objectArray = new Object[]{"catalog"};
            SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), null, false);
        }
        object = new String[]{SQLServerDatabaseMetaData.EscapeIDName(string3), SQLServerDatabaseMetaData.EscapeIDName(string2), string};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_STORED_PROCEDURES, (String[])object, getFunctionsColumnNames);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        Object object2;
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        if (string != null && string.length() == 0) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            object = new Object[]{"catalog"};
            SQLServerException.makeFromDriverError(null, null, ((Format)object2).format(object), null, false);
        }
        object2 = new String[]{SQLServerDatabaseMetaData.EscapeIDName(string3), SQLServerDatabaseMetaData.EscapeIDName(string2), string, SQLServerDatabaseMetaData.EscapeIDName(string4), "3"};
        object = this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_SPROC_COLUMNS, (String[])object2, getFunctionsColumnsColumnNames);
        ((SQLServerResultSet)object).getColumn(6).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            ((SQLServerResultSet)object).getColumn(8).setFilter(new ZeroFixupFilter());
            ((SQLServerResultSet)object).getColumn(9).setFilter(new ZeroFixupFilter());
            ((SQLServerResultSet)object).getColumn(17).setFilter(new ZeroFixupFilter());
        }
        return object;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.getResultSetFromInternalQueries(null, "SELECT cast(NULL as char(1)) as NAME, cast(0 as int) as MAX_LEN, cast(NULL as char(1)) as DEFAULT_VALUE, cast(NULL as char(1)) as DESCRIPTION  where 0 = 1");
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "R", 0 == n ? "C" : "T", bl ? "U" : "O", "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_SPECIAL_COLUMNS, stringArray, getBestRowIdentifierColumnNames);
        sQLServerResultSet.getColumn(3).setFilter(new DataTypeFilter());
        return sQLServerResultSet;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, string6, string5, string4};
        return this.getResultSetWithProvidedColumnNames(null, CallableHandles.SP_FKEYS, stringArray, pkfkColumnNames);
    }

    @Override
    public String getDatabaseProductName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft SQL Server";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLServerException {
        this.checkClosed();
        return this.connection.sqlServerVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return 4;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft JDBC Driver 4.0 for SQL Server";
    }

    @Override
    public String getDriverVersion() throws SQLServerException {
        int n = this.getDriverMinorVersion();
        String string = this.getDriverMajorVersion() + ".";
        string = string + "" + n;
        string = string + ".";
        string = string + 2206;
        string = string + ".";
        string = string + 100;
        return string;
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, null, null, null};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_FKEYS, stringArray, pkfkColumnNames);
    }

    @Override
    public String getExtraNameCharacters() throws SQLServerException {
        this.checkClosed();
        return "$#@";
    }

    @Override
    public String getIdentifierQuoteString() throws SQLServerException {
        this.checkClosed();
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{null, null, null, string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_FKEYS, stringArray, pkfkColumnNames);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "%", bl ? "Y" : "N", bl2 ? "Q" : "E"};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_STATISTICS, stringArray, getIndexInfoColumnNames);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLServerException {
        this.checkClosed();
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLServerException {
        this.checkClosed();
        return 4096;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLServerException {
        this.checkClosed();
        return 1024;
    }

    @Override
    public int getMaxConnections() throws SQLServerException {
        this.checkClosed();
        try {
            String string = "sp_configure 'user connections'";
            SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, string);
            if (!sQLServerResultSet.next()) {
                return 0;
            }
            return sQLServerResultSet.getInt("maximum");
        }
        catch (SQLServerException sQLServerException) {
            return 0;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLServerException {
        this.checkClosed();
        return 900;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxRowSize() throws SQLServerException {
        this.checkClosed();
        return 8060;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxStatementLength() throws SQLServerException {
        this.checkClosed();
        return 65536 * this.connection.getTDSPacketSize();
    }

    @Override
    public int getMaxStatements() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLServerException {
        this.checkClosed();
        return 256;
    }

    @Override
    public int getMaxUserNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public String getNumericFunctions() throws SQLServerException {
        this.checkClosed();
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_PKEYS, stringArray, getPrimaryKeysColumnNames);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3 = SQLServerDatabaseMetaData.EscapeIDName(string3), string2, string, string4 = SQLServerDatabaseMetaData.EscapeIDName(string4), "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_SPROC_COLUMNS, stringArray, getProcedureColumnsColumnNames);
        sQLServerResultSet.getColumn(6).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            sQLServerResultSet.getColumn(8).setFilter(new ZeroFixupFilter());
            sQLServerResultSet.getColumn(9).setFilter(new ZeroFixupFilter());
            sQLServerResultSet.getColumn(17).setFilter(new ZeroFixupFilter());
        }
        return sQLServerResultSet;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{SQLServerDatabaseMetaData.EscapeIDName(string3), string2, string};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_STORED_PROCEDURES, stringArray, getProceduresColumnNames);
    }

    @Override
    public String getProcedureTerm() throws SQLServerException {
        this.checkClosed();
        return "stored procedure";
    }

    @Override
    public ResultSet getSchemas() throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getSchemasInternal(null, null);
    }

    private ResultSet getSchemasInternal(String string, String string2) throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        String string3 = " ('dbo', 'guest','INFORMATION_SCHEMA','sys','db_owner', 'db_accessadmin', 'db_securityadmin', 'db_ddladmin'  ,'db_backupoperator','db_datareader','db_datawriter','db_denydatareader','db_denydatawriter') ";
        String string4 = "sys.schemas";
        String string5 = "sys.schemas.name";
        if (null != string && string.length() != 0) {
            string4 = string + "." + string4;
            string5 = string + "." + string5;
        }
        String string6 = "select " + string5 + " 'TABLE_SCHEM',";
        if (null != string && string.length() == 0) {
            string6 = string6 + "null 'TABLE_CATALOG' ";
        } else {
            string6 = string6 + " CASE WHEN " + string5 + "  IN " + string3 + " THEN null ELSE ";
            string6 = null != string && string.length() != 0 ? string6 + "'" + string + "' " : string6 + " DB_NAME() ";
            string6 = string6 + " END 'TABLE_CATALOG' ";
        }
        string6 = string6 + "   from " + string4;
        if (null != string && string.length() == 0) {
            string6 = null != string2 ? string6 + " where " + string5 + " like ?  and " : string6 + " where ";
            string6 = string6 + string5 + " in " + string3;
        } else if (null != string2) {
            string6 = string6 + " where " + string5 + " like ?  ";
        }
        string6 = string6 + " order by 2, 1";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " schema query (" + string6 + ")");
        }
        if (null == string2) {
            string = null;
            sQLServerResultSet = this.getResultSetFromInternalQueries(string, string6);
        } else {
            SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.connection.prepareStatement(string6);
            sQLServerPreparedStatement.setString(1, string2);
            sQLServerResultSet = (SQLServerResultSet)sQLServerPreparedStatement.executeQueryInternal();
        }
        return sQLServerResultSet;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        DriverJDBCVersion.checkSupportsJDBC4();
        return this.getSchemasInternal(string, string2);
    }

    @Override
    public String getSchemaTerm() throws SQLServerException {
        this.checkClosed();
        return "schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLServerException {
        this.checkClosed();
        return "\\";
    }

    @Override
    public String getSQLKeywords() throws SQLServerException {
        this.checkClosed();
        return "BACKUP,BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMPUTE,CONTAINS,CONTAINSTABLE,DATABASE,DBCC,DENY,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,EXIT,FILE,FILLFACTOR,FREETEXT,FREETEXTTABLE,FUNCTION,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,NOCHECK,NONCLUSTERED,OFF,OFFSETS,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OVER,PERCENT,PLAN,PRINT,PROC,RAISERROR,READTEXT,RECONFIGURE,REPLICATION,RESTORE,RETURN,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SETUSER,SHUTDOWN,STATISTICS,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    @Override
    public String getStringFunctions() throws SQLServerException {
        this.checkClosed();
        return "ASCII,CHAR,CONCAT, DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLServerException {
        this.checkClosed();
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray = new String[]{string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_TABLE_PRIVILEGES, stringArray, getTablePrivilegesColumnNames);
    }

    @Override
    public ResultSet getTableTypes() throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String string = "SELECT 'VIEW' 'TABLE_TYPE' UNION SELECT 'TABLE' UNION SELECT 'SYSTEM TABLE'";
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, string);
        return sQLServerResultSet;
    }

    @Override
    public String getTimeDateFunctions() throws SQLServerException {
        this.checkClosed();
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = this.connection.isKatmaiOrLater() ? this.getResultSetFromInternalQueries(null, "sp_datatype_info_100 @ODBCVer=3") : this.getResultSetFromInternalQueries(null, "sp_datatype_info @ODBCVer=3");
        sQLServerResultSet.setColumnName(11, "FIXED_PREC_SCALE");
        sQLServerResultSet.getColumn(2).setFilter(new DataTypeFilter());
        return sQLServerResultSet;
    }

    @Override
    public String getURL() throws SQLServerException {
        this.checkClosed();
        StringBuilder stringBuilder = new StringBuilder();
        Properties properties = this.connection.activeConnectionProperties;
        DriverPropertyInfo[] driverPropertyInfoArray = SQLServerDriver.getPropertyInfoFromProperties(properties);
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = driverPropertyInfoArray.length;
        while (--n >= 0) {
            String string4;
            String string5 = driverPropertyInfoArray[n].name;
            if (string5.equals(SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.toString()) || string5.equals(SQLServerDriverStringProperty.USER.toString()) || string5.equals(SQLServerDriverStringProperty.PASSWORD.toString()) || 0 == (string4 = driverPropertyInfoArray[n].value).length()) continue;
            if (string5.equals(SQLServerDriverStringProperty.SERVER_NAME.toString())) {
                string = string4;
                continue;
            }
            if (string5.equals(SQLServerDriverStringProperty.INSTANCE_NAME.toString())) {
                string3 = string4;
                continue;
            }
            if (string5.equals(SQLServerDriverIntProperty.PORT_NUMBER.toString())) {
                string2 = string4;
                continue;
            }
            stringBuilder.append(string5);
            stringBuilder.append("=");
            stringBuilder.append(string4);
            stringBuilder.append(";");
        }
        stringBuilder.insert(0, ";");
        stringBuilder.insert(0, string2);
        stringBuilder.insert(0, ":");
        if (null != string3) {
            stringBuilder.insert(0, string3);
            stringBuilder.insert(0, "\\");
        }
        stringBuilder.insert(0, string);
        stringBuilder.insert(0, urlprefix);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        SQLServerStatement sQLServerStatement = null;
        SQLServerResultSet sQLServerResultSet = null;
        String string = "";
        try {
            sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
            sQLServerResultSet = sQLServerStatement.executeQueryInternal("select system_user");
            boolean bl = sQLServerResultSet.next();
            assert (bl);
            string = sQLServerResultSet.getString(1);
        }
        finally {
            if (sQLServerResultSet != null) {
                sQLServerResultSet.close();
            }
            if (sQLServerStatement != null) {
                sQLServerStatement.close();
            }
        }
        return string;
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "V", "T", "U", "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, CallableHandles.SP_SPECIAL_COLUMNS, stringArray, getVersionColumnsColumnNames);
        sQLServerResultSet.getColumn(3).setFilter(new DataTypeFilter());
        return sQLServerResultSet;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLServerException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        this.checkConcurrencyType(n2);
        switch (n) {
            case 1003: 
            case 1005: 
            case 1006: 
            case 2004: {
                return true;
            }
            case 1004: 
            case 2003: {
                return 1007 == n2;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 2004 == n;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return 1005 == n;
    }

    private void checkResultType(int n) throws SQLServerException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    private void checkConcurrencyType(int n) throws SQLServerException {
        switch (n) {
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as CLASS_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as REMARKS, cast(0 as smallint) as BASE_TYPE where 0 = 1");
    }

    @Override
    public Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection.getConnection();
    }

    @Override
    public int getSQLStateType() throws SQLServerException {
        this.checkClosed();
        if (this.connection != null && this.connection.xopenStates) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n > 0 && n2 > 0) {
            string = string.substring(n + 1, n2);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLServerException {
        this.checkClosed();
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return 1;
    }

    public RowIdLifetime getRowIdLifetime() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLServerException {
        this.checkClosed();
        if (1 == n || 2 == n) {
            return true;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as ATTR_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as ATTR_TYPE_NAME, cast(0 as int) as ATTR_SIZE, cast(0 as int) as DECIMAL_DIGITS, cast(0 as int) as NUM_PREC_RADIX, cast(0 as int) as NULLABLE, cast(NULL as char(1)) as REMARKS, cast(NULL as char(1)) as ATTR_DEF, cast(0 as int) as SQL_DATA_TYPE, cast(0 as int) as SQL_DATETIME_SUB, cast(0 as int) as CHAR_OCTET_LENGTH, cast(0 as int) as ORDINAL_POSITION, cast(NULL as char(1)) as IS_NULLABLE, cast(NULL as char(1)) as SCOPE_CATALOG, cast(NULL as char(1)) as SCOPE_SCHEMA, cast(NULL as char(1)) as SCOPE_TABLE, cast(0 as smallint) as SOURCE_DATA_TYPE where 0 = 1");
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTABLE_NAME where 0 = 1");
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTYPE_CAT, cast(NULL as char(1)) as SUPERTYPE_SCHEM, cast(NULL as char(1)) as SUPERTYPE_NAME where 0 = 1");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return true;
    }

    final class HandleAssociation {
        final String databaseName;
        final CallableStatement stmt;

        HandleAssociation(String string, CallableStatement callableStatement) {
            this.databaseName = string;
            this.stmt = callableStatement;
        }

        final void close() throws SQLServerException {
            ((SQLServerCallableStatement)this.stmt).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CallableHandles {
        SP_COLUMNS("{ call sp_columns(?, ?, ?, ?, ?) }", "{ call sp_columns_100(?, ?, ?, ?, ?, ?) }"),
        SP_COLUMN_PRIVILEGES("{ call sp_column_privileges(?, ?, ?, ?)}", "{ call sp_column_privileges(?, ?, ?, ?)}"),
        SP_TABLES("{ call sp_tables(?, ?, ?, ?) }", "{ call sp_tables(?, ?, ?, ?) }"),
        SP_SPECIAL_COLUMNS("{ call sp_special_columns (?, ?, ?, ?, ?, ?, ?)}", "{ call sp_special_columns_100 (?, ?, ?, ?, ?, ?, ?)}"),
        SP_FKEYS("{ call sp_fkeys (?, ?, ?, ? , ? ,?)}", "{ call sp_fkeys (?, ?, ?, ? , ? ,?)}"),
        SP_STATISTICS("{ call sp_statistics(?,?,?,?,?, ?) }", "{ call sp_statistics_100(?,?,?,?,?, ?) }"),
        SP_SPROC_COLUMNS("{ call sp_sproc_columns(?, ?, ?,?,?) }", "{ call sp_sproc_columns_100(?, ?, ?,?,?) }"),
        SP_STORED_PROCEDURES("{call sp_stored_procedures(?, ?, ?) }", "{call sp_stored_procedures(?, ?, ?) }"),
        SP_TABLE_PRIVILEGES("{call sp_table_privileges(?,?,?) }", "{call sp_table_privileges(?,?,?) }"),
        SP_PKEYS("{ call sp_pkeys (?, ?, ?)}", "{ call sp_pkeys (?, ?, ?)}");

        private final String preKatProc;
        private final String katProc;

        private CallableHandles(String string2, String string3) {
            this.preKatProc = string2;
            this.katProc = string3;
        }

        CallableStatement prepare(SQLServerConnection sQLServerConnection) throws SQLServerException {
            return sQLServerConnection.prepareCall(sQLServerConnection.isKatmaiOrLater() ? this.katProc : this.preKatProc);
        }
    }
}

