/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Savepoint;
import java.text.MessageFormat;

public final class SQLServerSavepoint
implements Savepoint {
    private final String sName;
    private final int nId;
    private final SQLServerConnection con;

    public SQLServerSavepoint(SQLServerConnection sQLServerConnection, String string) {
        this.con = sQLServerConnection;
        if (string == null) {
            this.nId = sQLServerConnection.getNextSavepointId();
            this.sName = null;
        } else {
            this.sName = string;
            this.nId = 0;
        }
    }

    public String getSavepointName() throws SQLServerException {
        if (this.sName == null) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_savepointNotNamed"), null, false);
        }
        return this.sName;
    }

    public String getLabel() {
        if (this.sName == null) {
            return "S" + this.nId;
        }
        return this.sName;
    }

    public boolean isNamed() {
        return this.sName != null;
    }

    public int getSavepointId() throws SQLServerException {
        if (this.sName != null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_savepointNamed"));
            Object[] objectArray = new Object[]{new String(this.sName)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, false);
        }
        return this.nId;
    }
}

