/*
 * Decompiled with CFR 0.152.
 */
package com.ibeetl.starter;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class BeetlSqlSingleCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment env = context.getEnvironment();
        boolean enable = this.enableBeetlSql(env);
        boolean mutipleDataSource = this.hasMutipleDatasource(env);
        if (!enable) {
            return false;
        }
        return enable && !mutipleDataSource;
    }

    protected boolean enableBeetlSql(Environment env) {
        String enableStr = env.getProperty("beetlsql.enabled");
        if (StringUtils.isEmpty((Object)enableStr)) {
            return true;
        }
        boolean enable = Boolean.parseBoolean(enableStr.trim());
        return enable;
    }

    protected boolean hasMutipleDatasource(Environment env) {
        String sourceList = env.getProperty("beetlsql.mutiple.datasource");
        return !StringUtils.isEmpty((Object)sourceList);
    }
}

