/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.BeetlParserException;
import org.beetl.core.om.GeneralGetMethodInvoker;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectInfo;
import org.beetl.core.om.ObjectMethodMatchConf;
import org.beetl.core.om.PojoMethodInvoker;

public class ObjectUtil {
    static Map<String, MethodInvoker> methodInvokerCache = new ConcurrentHashMap<String, MethodInvoker>();
    public static Map<Class, ObjectInfo> cachedClassInfoMap = new ConcurrentHashMap<Class, ObjectInfo>();
    public static Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Object copy(Object o) {
        if (o instanceof Serializable) {
            try {
                ByteArrayOutputStream bs = new ByteArrayOutputStream(128);
                ObjectOutputStream dos = new ObjectOutputStream(bs);
                dos.writeObject(o);
                ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
                ObjectInputStream ios = new ObjectInputStream(is);
                Object copy = ios.readObject();
                return copy;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getGetMethod(String attrName) {
        StringBuilder mbuffer = new StringBuilder("get");
        mbuffer.append(attrName.substring(0, 1).toUpperCase()).append(attrName.substring(1));
        return mbuffer.toString();
    }

    public static String getSetMethod(String attrName) {
        StringBuilder mbuffer = new StringBuilder("set");
        mbuffer.append(attrName.substring(0, 1).toUpperCase()).append(attrName.substring(1));
        return mbuffer.toString();
    }

    public static String getIsMethod(String attrName) {
        StringBuilder mbuffer = new StringBuilder("is");
        mbuffer.append(attrName.substring(0, 1).toUpperCase()).append(attrName.substring(1));
        return mbuffer.toString();
    }

    public static MethodInvoker getInvokder(Class c, String name) {
        String key = c.toString().concat("_").concat(name);
        MethodInvoker invoker = methodInvokerCache.get(key);
        if (invoker != null) {
            return invoker;
        }
        String methodName = ObjectUtil.getGetMethod(name);
        Method method = ObjectUtil.getGetMethod(c, methodName, null);
        if (method != null) {
            invoker = new PojoMethodInvoker(method);
        } else {
            methodName = ObjectUtil.getIsMethod(name);
            method = ObjectUtil.getGetMethod(c, methodName, null);
            if (method != null) {
                invoker = new PojoMethodInvoker(method);
            } else {
                method = ObjectUtil.getGetMethod(c, "get", String.class);
                if (method != null) {
                    invoker = new GeneralGetMethodInvoker(method, name);
                }
            }
        }
        if (invoker != null) {
            methodInvokerCache.put(key, invoker);
            return invoker;
        }
        return null;
    }

    public static Method getGetMethod(Class c, String methodName, Class ... paras) {
        try {
            Method m = c.getMethod(methodName, paras);
            m.setAccessible(true);
            return m;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static ObjectMethodMatchConf match(Method method, Class[] paras) {
        Class<?>[] metodParaTypes = method.getParameterTypes();
        if (paras.length < metodParaTypes.length) {
            return null;
        }
        if (!(paras.length == metodParaTypes.length || paras.length > metodParaTypes.length && metodParaTypes.length != 0 && metodParaTypes[metodParaTypes.length - 1].isArray())) {
            return null;
        }
        int[] convert = new int[metodParaTypes.length];
        for (int j = 0; j < paras.length; ++j) {
            if (paras[j] == null) {
                convert[j] = 0;
                continue;
            }
            if (paras[j] == metodParaTypes[j]) {
                convert[j] = 0;
                continue;
            }
            if (metodParaTypes[j] == Object.class) {
                convert[j] = 0;
                continue;
            }
            if (metodParaTypes[j].isAssignableFrom(paras[j])) {
                convert[j] = 0;
                continue;
            }
            if (metodParaTypes[j].isPrimitive() && Number.class.isAssignableFrom(paras[j])) {
                if (metodParaTypes[j] == Integer.TYPE) {
                    convert[j] = 1;
                    continue;
                }
                if (metodParaTypes[j] == Byte.TYPE) {
                    convert[j] = 7;
                    continue;
                }
                if (metodParaTypes[j] == Character.TYPE) {
                    convert[j] = 8;
                    continue;
                }
                if (metodParaTypes[j] == Long.TYPE) {
                    convert[j] = 2;
                    continue;
                }
                if (metodParaTypes[j] == Double.TYPE) {
                    convert[j] = 3;
                    continue;
                }
                if (metodParaTypes[j] == Float.TYPE) {
                    convert[j] = 4;
                    continue;
                }
                if (metodParaTypes[j] != Short.TYPE) continue;
                convert[j] = 5;
                continue;
            }
            if (Number.class.isAssignableFrom(metodParaTypes[j]) && Number.class.isAssignableFrom(paras[j])) {
                if (metodParaTypes[j] == Integer.class) {
                    convert[j] = 1;
                    continue;
                }
                if (metodParaTypes[j] == Byte.class) {
                    convert[j] = 7;
                    continue;
                }
                if (metodParaTypes[j] == Character.class) {
                    convert[j] = 8;
                    continue;
                }
                if (metodParaTypes[j] == Long.class) {
                    convert[j] = 2;
                    continue;
                }
                if (metodParaTypes[j] == Double.class) {
                    convert[j] = 3;
                    continue;
                }
                if (metodParaTypes[j] == Float.class) {
                    convert[j] = 4;
                    continue;
                }
                if (metodParaTypes[j] == Short.class) {
                    convert[j] = 5;
                    continue;
                }
                if (metodParaTypes[j] != BigDecimal.class) continue;
                convert[j] = 6;
                continue;
            }
            if (metodParaTypes[j] == Boolean.class) {
                if (paras[j] == Boolean.TYPE) {
                    convert[j] = 0;
                    continue;
                }
            } else if (metodParaTypes[j] == Boolean.TYPE) {
                if (paras[j] == Boolean.class) {
                    convert[j] = 0;
                    continue;
                }
            } else if (metodParaTypes[j] == Character.class) {
                if (paras[j] == Character.TYPE) {
                    convert[j] = 8;
                    continue;
                }
            } else if (metodParaTypes[j] == Character.TYPE) {
                if (paras[j] == Character.class) {
                    convert[j] = 8;
                    continue;
                }
            } else if (metodParaTypes[j].isArray()) {
                if (paras[j].isArray()) {
                    Class<?> paraTypeComponent;
                    Class<?> metodParaTypeComponent = metodParaTypes[j].getComponentType();
                    if (metodParaTypeComponent == (paraTypeComponent = paras[j].getComponentType())) {
                        convert[j] = 0;
                        continue;
                    }
                    return null;
                }
                if (j == metodParaTypes.length - 1) {
                    convert[j] = 9;
                    break;
                }
                return null;
            }
            return null;
        }
        ObjectMethodMatchConf mc = new ObjectMethodMatchConf();
        mc.method = method;
        mc.convert = convert;
        for (int c : convert) {
            if (c == 0) continue;
            mc.isNeedConvert = true;
            break;
        }
        mc.method.setAccessible(true);
        return mc;
    }

    private static Object invoke(Class target, Object o, String methodName, Object[] paras) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ObjectInfo info = ObjectUtil.getObjectInfo(target);
        Class[] parameterType = new Class[paras.length];
        int i = 0;
        for (Object para : paras) {
            parameterType[i++] = para == null ? null : para.getClass();
        }
        ObjectMethodMatchConf mf = ObjectUtil.findMethod(target, methodName, parameterType);
        if (mf == null) {
            throw new BeetlParserException("NATIVE_CALL_INVALID", "\u6839\u636e\u53c2\u6570\u672a\u627e\u5230\u5339\u914d\u7684\u65b9\u6cd5");
        }
        Object result = ObjectUtil.invoke(o, mf, paras);
        return result;
    }

    public static Object invokeStatic(Class target, String methodName, Object[] paras) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ObjectUtil.invoke(target, null, methodName, paras);
    }

    public static Object invokeObject(Object o, String methodName, Object[] paras) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> target = o.getClass();
        return ObjectUtil.invoke(target, o, methodName, paras);
    }

    public static Object invoke(Object o, ObjectMethodMatchConf conf, Object[] paras) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] targets = conf.convert(paras);
        if (o == null && !Modifier.isStatic(conf.method.getModifiers())) {
            throw new BeetlException("NULL", "\u8be5\u65b9\u6cd5\u662f\u975e\u9759\u6001\u65b9\u6cd5\uff0c\u4e0d\u80fd\u9759\u6001\u5f62\u5f0f\u8c03\u7528");
        }
        conf.method.setAccessible(true);
        return conf.method.invoke(o, targets);
    }

    public static ObjectMethodMatchConf findMethod(Class target, String methodName, Class[] parameterType) {
        List<Method> ms = ObjectUtil.getObjectInfo(target).getMethods(methodName);
        if (ms == null || ms.size() == 0) {
            return null;
        }
        Method temp = null;
        for (int i = 0; i < ms.size(); ++i) {
            temp = ms.get(i);
            ObjectMethodMatchConf selfMc = ObjectUtil.match(temp, parameterType);
            if (selfMc == null) continue;
            return selfMc;
        }
        return null;
    }

    public static Class getClassByName(String clsName) {
        try {
            return Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object instance(String clsName) {
        try {
            return Class.forName(clsName).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object tryInstance(String clsName) {
        try {
            return ObjectUtil.instance(clsName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectInfo getObjectInfo(Class c) {
        ObjectInfo info = cachedClassInfoMap.get(c);
        if (info == null) {
            Class clazz = c;
            synchronized (clazz) {
                info = new ObjectInfo(c);
                cachedClassInfoMap.put(c, info);
            }
        }
        return info;
    }
}

