/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.Reader;
import org.beetl.core.ResourceLoader;

public abstract class Resource {
    protected ResourceLoader resourceLoader = null;
    protected String id = null;

    public Resource(String id, ResourceLoader loader) {
        this.id = id;
        this.resourceLoader = loader;
    }

    public abstract Reader openReader();

    public abstract boolean isModified();

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getId() {
        return this.id;
    }

    public String getContent(int start, int end) throws IOException {
        int ch;
        Reader br = this.openReader();
        int line = 1;
        boolean hasStart = false;
        StringBuilder sb = new StringBuilder(1024);
        while ((ch = br.read()) != -1) {
            if (line == start) {
                hasStart = true;
            }
            if (hasStart) {
                sb.append((char)ch);
            }
            if (ch != 13 && ch != 10) continue;
            ++line;
            char temp = (char)ch;
            ch = br.read();
            if (ch == -1) break;
            if (temp == '\r' && ch == 10) {
                if (hasStart) {
                    sb.append((char)ch);
                }
            } else if (temp == '\n' && ch == 13) {
                if (hasStart) {
                    sb.append((char)ch);
                }
            } else if (line != end && hasStart) {
                sb.append((char)ch);
            }
            if (line != end) continue;
            break;
        }
        return sb.toString();
    }
}

