/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.fn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegxFunctionUtil {
    public boolean match(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        if (regex.trim().isEmpty()) {
            return true;
        }
        return Pattern.compile(regex.trim()).matcher(str).find();
    }

    public String replace(String str, String regex, String replace) {
        if (str == null) {
            return "";
        }
        if (regex == null) {
            return str;
        }
        if (replace == null) {
            replace = "";
        }
        return str.replaceAll(regex, replace);
    }

    public String find(String str, String regex) {
        if (str == null || regex == null) {
            return "";
        }
        Matcher m = Pattern.compile(regex).matcher(str);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    public List<String> findList(String str, String regex) {
        ArrayList<String> ret = new ArrayList<String>();
        if (str == null || regex == null) {
            return ret;
        }
        Matcher m = Pattern.compile(regex).matcher(str);
        while (m.find()) {
            ret.add(m.group());
        }
        return ret;
    }

    public List<String> split(String str, String regex) {
        if (str == null || regex == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(str.split(regex));
    }

    public List<String> splitLimit(String str, String regex, int limit) {
        if (str == null || regex == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(str.split(regex, limit));
    }

    public static void main(String[] args) {
    }
}

