/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.beetl.core.GroupTemplate;
import org.beetl.core.exception.ScriptEvalError;
import org.beetl.ext.web.SessionWrapper;
import org.beetl.ext.web.WebRender;
import org.beetl.ext.web.WebVariable;

public abstract class SimpleCrossFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        if (this.canProcceed((ServletRequest)req, response)) {
            String path = req.getServletPath();
            String valueFile = this.getValueFile(path, req, rsp);
            GroupTemplate gt = this.getGroupTemplate();
            WebRender render = new WebRender(gt);
            Map paras = this.getScriptParas(req, rsp);
            String commonFile = this.getCommonValueFile(req, rsp);
            Map commonData = new HashMap();
            Map data = new HashMap();
            try {
                if (gt.getResourceLoader().exist(commonFile)) {
                    commonData = gt.runScript(commonFile, paras);
                }
                if (gt.getResourceLoader().exist(valueFile)) {
                    data = gt.runScript(valueFile, paras);
                }
            }
            catch (ScriptEvalError e) {
                throw new RuntimeException("\u4f2a\u6a21\u578b\u811a\u672c\u6709\u9519\uff01", e);
            }
            commonData.putAll(data);
            for (String key : commonData.keySet()) {
                Object value = commonData.get(key);
                this.setValue(key, value, req);
            }
            String renderPath = this.getRenderPath(path, req, rsp);
            render.render(renderPath, req, rsp, new Object[0]);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void setValue(String key, Object value, HttpServletRequest hq) {
        if (key.equals("session")) {
            HttpSession session = hq.getSession();
            Map map = (Map)value;
            for (String sessionKey : map.keySet()) {
                Object sessionValue = map.get(sessionKey);
                session.setAttribute(sessionKey, sessionValue);
            }
        } else {
            hq.setAttribute(key, value);
        }
    }

    protected String getValueFile(String path, HttpServletRequest hq, HttpServletResponse response) {
        return "/values/" + path + ".var";
    }

    protected String getCommonValueFile(HttpServletRequest hq, HttpServletResponse response) {
        return "/values/common.var";
    }

    protected String getRenderPath(String path, HttpServletRequest request, HttpServletResponse response) {
        return path;
    }

    protected void output(String result, ServletResponse response) throws IOException {
        response.getWriter().print(result);
    }

    protected Map getScriptParas(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            map.put(attrName, request.getAttribute(attrName));
        }
        WebVariable webVariable = new WebVariable();
        webVariable.setRequest(request);
        webVariable.setResponse(response);
        webVariable.setSession(request.getSession());
        map.put("session", new SessionWrapper(request, webVariable.getSession()));
        map.put("servlet", webVariable);
        map.put("request", request);
        map.put("ctxPath", request.getContextPath());
        return map;
    }

    protected abstract GroupTemplate getGroupTemplate();

    protected boolean canProcceed(ServletRequest request, ServletResponse response) {
        return true;
    }
}

