/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ContextLocalBuffer {
    public static int charBufferSize = 256;
    public static int byteBufferSize = 256;
    private char[] charBuffer = new char[charBufferSize];
    private byte[] byteBuffer = new byte[byteBufferSize];
    static ThreadLocalMap threadLocal = new ThreadLocalMap();

    public static ContextLocalBuffer get() {
        SoftReference<ContextLocalBuffer> re = threadLocal.get();
        ContextLocalBuffer ctxBuffer = re.get();
        if (ctxBuffer == null) {
            ctxBuffer = new ContextLocalBuffer();
            threadLocal.set(new SoftReference<ContextLocalBuffer>(ctxBuffer));
        }
        return ctxBuffer;
    }

    public static void clear() {
        threadLocal.clear();
    }

    public char[] getCharBuffer() {
        return this.charBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public char[] getCharBuffer(int expected) {
        if (this.charBuffer.length >= expected) {
            return this.charBuffer;
        }
        this.charBuffer = new char[(int)((double)expected * 1.2)];
        return this.charBuffer;
    }

    public byte[] getByteBuffer(int expected) {
        if (this.byteBuffer.length >= expected) {
            return this.byteBuffer;
        }
        this.byteBuffer = new byte[(int)((double)expected * 1.2)];
        return this.byteBuffer;
    }

    static class ThreadLocalMap {
        public ConcurrentMap<Thread, SoftReference<ContextLocalBuffer>> map = new ConcurrentHashMap<Thread, SoftReference<ContextLocalBuffer>>();

        ThreadLocalMap() {
        }

        public SoftReference<ContextLocalBuffer> get() {
            Thread thread = Thread.currentThread();
            SoftReference<ContextLocalBuffer> soft = (SoftReference<ContextLocalBuffer>)this.map.get(thread);
            if (soft == null) {
                soft = new SoftReference<ContextLocalBuffer>(new ContextLocalBuffer());
                this.map.put(thread, soft);
            }
            return soft;
        }

        public void set(SoftReference<ContextLocalBuffer> o) {
            Thread thread = Thread.currentThread();
            this.map.put(thread, o);
        }

        public void clear() {
            this.map.clear();
        }
    }
}

