/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.VarDefineNode;

public class TryCatchStatement
extends Statement {
    BlockStatement tryPart;
    BlockStatement catchPart;
    VarDefineNode error;

    public TryCatchStatement(BlockStatement tryPart, BlockStatement catchPart, VarDefineNode error, GrammarToken token) {
        super(token);
        this.tryPart = tryPart;
        this.catchPart = catchPart;
        this.error = error;
    }

    @Override
    public void execute(Context ctx) {
        try {
            this.tryPart.execute(ctx);
        }
        catch (Exception ex) {
            if (this.catchPart != null) {
                if (this.error != null) {
                    ctx.vars[this.error.varIndex] = ex instanceof BeetlException ? ex : new BeetlException("ERROR", ex.getMessage(), ex);
                }
                this.catchPart.execute(ctx);
            }
            if (ex instanceof BeetlException) {
                throw (BeetlException)ex;
            }
            BeetlException be = new BeetlException("ERROR", ex.getMessage(), ex);
            be.pushToken(this.tryPart.token);
            throw be;
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.tryPart.infer(inferCtx);
        if (this.catchPart != null) {
            this.catchPart.infer(inferCtx);
        }
    }
}

