/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.cache;

import java.util.concurrent.ArrayBlockingQueue;
import org.beetl.core.cache.ContextBuffer;
import org.jetbrains.annotations.NotNull;

public class ContextLocalBuffers {
    private final ArrayBlockingQueue<ContextBuffer> queue;
    private final int bufferMax;

    public ContextLocalBuffers(int num, int bufferMax) {
        this.bufferMax = bufferMax;
        this.queue = new ArrayBlockingQueue(num);
        for (int i = 0; i < num; ++i) {
            ContextBuffer buffer = new ContextBuffer(bufferMax, true);
            this.queue.add(buffer);
        }
    }

    @NotNull
    public ContextBuffer getContextLocalBuffer() {
        ContextBuffer buffer = this.queue.poll();
        return buffer == null ? new ContextBuffer(this.bufferMax, false) : buffer;
    }

    public void putContextLocalBuffer(@NotNull ContextBuffer buffer) {
        if (!buffer.inner) {
            return;
        }
        this.queue.add(buffer);
    }
}

