/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.AABuilder;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.VarAttribute;

public class VarRef
extends Expression
implements IVarIndex {
    public VarAttribute[] attributes;
    public Expression safe;
    public int varIndex;
    public boolean hasSafe;
    public GrammarToken firstToken = null;

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token) {
        this(attributes, hasSafe, safe, token, token);
    }

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
        super(token);
        this.attributes = attributes;
        this.safe = safe;
        this.hasSafe = hasSafe;
        this.firstToken = firstToken;
    }

    @Override
    public Object evaluate(Context ctx) {
        Result ret = this.getValue(ctx);
        if (ret.safe) {
            return ret.value;
        }
        Object value = ret.value;
        if (this.attributes.length == 0) {
            return value;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                if (this.hasSafe || ctx.safeOutput) {
                    return this.safe == null ? null : this.safe.evaluate(ctx);
                }
                throw new BeetlException("NULL", "\u7a7a\u6307\u9488").pushToken(i == 0 ? this.firstToken : this.attributes[i - 1].token);
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                throw ex.pushToken(attr.token);
            }
            catch (RuntimeException ex) {
                throw new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex).pushToken(attr.token);
            }
        }
        if (value == null && (this.hasSafe || ctx.safeOutput)) {
            return this.safe == null ? null : this.safe.evaluate(ctx);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Result getValue(Context ctx) {
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            if (ctx.globalVar != null && ctx.globalVar.containsKey("_root")) {
                Object root = ctx.getGlobal("_root");
                String attr = this.firstToken.text;
                if (root == null) {
                    if (!this.hasSafe && !ctx.safeOutput) throw new BeetlException("NULL", "_root\u4e3a\u7a7a\u6307\u9488\uff0c\u65e0" + this.firstToken.text + "\u503c").pushToken(this.firstToken);
                    return new Result(this.safe == null ? null : this.safe.evaluate(ctx), true);
                }
                AttributeAccess aa = AABuilder.buildFiledAccessor(root.getClass());
                try {
                    value = aa.value(root, attr);
                }
                catch (RuntimeException e) {
                    throw new BeetlException("ATTRIBUTE_INVALID", "\u8bbf\u95ee _root " + root.getClass() + "." + attr + " \u5c5e\u6027\u8bbf\u95ee\u9519\u8bef").pushToken(this.firstToken);
                }
                ctx.vars[this.varIndex] = value;
                return new Result(value);
            }
            if (this.hasSafe || ctx.safeOutput) {
                return new Result(this.safe == null ? null : this.safe.evaluate(ctx), true);
            }
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        if (value != null || !this.hasSafe && !ctx.safeOutput) return new Result(value);
        return new Result(this.safe == null ? null : this.safe.evaluate(ctx), true);
    }

    public Object evaluateUntilLast(Context ctx) {
        if (this.attributes.length == 0) {
            throw new RuntimeException();
        }
        Result ret = this.getValue(ctx);
        Object value = ret.value;
        if (value == null) {
            throw new BeetlException("NULL").pushToken(this.firstToken);
        }
        for (int i = 0; i < this.attributes.length - 1; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                throw new BeetlException("NULL", "\u7a7a\u6307\u9488").pushToken(i == 0 ? this.firstToken : this.attributes[i - 1].token);
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                throw ex.pushToken(attr.token);
            }
            catch (RuntimeException ex) {
                throw new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex).pushToken(attr.token);
            }
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    protected class Result {
        public Object value;
        public boolean safe = false;

        public Result(Object value, boolean safe) {
            this.value = value;
            this.safe = safe;
        }

        public Result(Object value) {
            this(value, false);
        }
    }
}

