/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.fun;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.FunctionWrapper;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.om.ObjectMethodMatchConf;

public class MutipleFunctionWrapper
extends FunctionWrapper {
    Method[] ms = null;
    String methodName = null;
    MethodContext[] mcs = null;

    public MutipleFunctionWrapper(String funName, Class cls, Object target, Method[] ms) {
        super(funName);
        this.ms = ms;
        this.target = target;
        this.cls = cls;
        int index = this.functionName.lastIndexOf(".");
        this.methodName = index != -1 ? this.functionName.substring(index + 1) : this.functionName;
        ArrayList<MethodContext> list = new ArrayList<MethodContext>();
        for (Method m : ms) {
            Class<?>[] paraType = m.getParameterTypes();
            MethodContext mc = new MethodContext();
            mc.m = m;
            mc.parasType = paraType;
            if (paraType.length != 0 && paraType[paraType.length - 1] == Context.class) {
                mc.contextRequired = true;
            }
            list.add(mc);
        }
        this.mcs = list.toArray(new MethodContext[0]);
    }

    @Override
    public Object call(Object[] paras, Context ctx) {
        Class[] parameterType = null;
        try {
            Class[] parameterContextType = null;
            Class[] parameterNoContextType = null;
            for (MethodContext mc : this.mcs) {
                if (mc.contextRequired) {
                    if (parameterContextType == null) {
                        parameterContextType = new Class[paras.length + 1];
                        int i = 0;
                        for (Object para : paras) {
                            parameterContextType[i++] = para != null ? para.getClass() : null;
                        }
                        parameterContextType[i] = Context.class;
                    }
                    parameterType = parameterContextType;
                } else {
                    if (parameterNoContextType == null) {
                        parameterNoContextType = new Class[paras.length];
                        int i = 0;
                        for (Object para : paras) {
                            parameterNoContextType[i++] = para != null ? para.getClass() : null;
                        }
                    }
                    parameterType = parameterNoContextType;
                }
                ObjectMethodMatchConf conf = ObjectUtil.match(mc.m, parameterType);
                if (conf == null) continue;
                Object[] newParas = null;
                newParas = mc.contextRequired ? this.getContextParas(paras, ctx) : paras;
                newParas = conf.convert(newParas);
                return mc.m.invoke(this.target, newParas);
            }
        }
        catch (IllegalArgumentException e) {
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u53c2\u6570\u4e0d\u5339\u914d " + this.functionName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u975e\u6cd5\u8bbf\u95ee\u65b9\u6cd5 " + this.functionName, e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof BeetlException) {
                throw (BeetlException)t;
            }
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.functionName, t);
        }
        throw new BeetlException("NATIVE_CALL_INVALID", "\u627e\u4e0d\u5230\u65b9\u6cd5 " + this.functionName + BeetlUtil.getParameterDescription(parameterType));
    }

    public Class getReturnType(Class[] parameterType) {
        Class[] parameterContextType = null;
        Object parameterNoContextType = null;
        for (MethodContext mc : this.mcs) {
            if (mc.contextRequired) {
                parameterContextType = new Class[parameterType.length + 1];
                System.arraycopy(parameterType, 0, parameterContextType, 0, parameterType.length);
            } else {
                parameterContextType = parameterType;
            }
            ObjectMethodMatchConf matchConf = ObjectUtil.findMethod(this.target.getClass(), this.methodName, parameterContextType);
            if (matchConf == null) continue;
            return matchConf.method.getReturnType();
        }
        return Object.class;
    }

    class MethodContext {
        public Method m;
        public boolean contextRequired;
        public Class[] parasType;

        MethodContext() {
        }
    }
}

