/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.android.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.beetl.android.internal.util.EmptyArray;
import org.beetl.android.util.ArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    public static byte[] newUnpaddedByteArray(int minLen) {
        return (byte[])Array.newInstance(Byte.TYPE, minLen);
    }

    public static char[] newUnpaddedCharArray(int minLen) {
        return (char[])Array.newInstance(Character.TYPE, minLen);
    }

    public static int[] newUnpaddedIntArray(int minLen) {
        return (int[])Array.newInstance(Integer.TYPE, minLen);
    }

    public static boolean[] newUnpaddedBooleanArray(int minLen) {
        return (boolean[])Array.newInstance(Boolean.TYPE, minLen);
    }

    public static long[] newUnpaddedLongArray(int minLen) {
        return (long[])Array.newInstance(Long.TYPE, minLen);
    }

    public static float[] newUnpaddedFloatArray(int minLen) {
        return (float[])Array.newInstance(Float.TYPE, minLen);
    }

    public static Object[] newUnpaddedObjectArray(int minLen) {
        return (Object[])Array.newInstance(Object.class, minLen);
    }

    public static <T> T[] newUnpaddedArray(Class<T> clazz, int minLen) {
        return (Object[])Array.newInstance(clazz, minLen);
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length < length || array2.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] emptyArray(Class<T> kind) {
        if (kind == Object.class) {
            return EmptyArray.OBJECT;
        }
        int bucket = (kind.hashCode() & Integer.MAX_VALUE) % 73;
        Object cache = sCache[bucket];
        if (cache == null || cache.getClass().getComponentType() != kind) {
            ArrayUtils.sCache[bucket] = cache = Array.newInstance(kind, 0);
        }
        return (Object[])cache;
    }

    public static boolean isEmpty(@Nullable Collection<?> array) {
        return array == null || array.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isEmpty(@Nullable T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable boolean[] array) {
        return array == null || array.length == 0;
    }

    public static int size(@Nullable Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static int size(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static <T> boolean contains(@Nullable T[] array, T value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static <T> int indexOf(@Nullable T[] array, T value) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean containsAll(@Nullable T[] array, T[] check) {
        if (check == null) {
            return true;
        }
        for (T checkItem : check) {
            if (ArrayUtils.contains(array, checkItem)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAny(@Nullable T[] array, T[] check) {
        if (check == null) {
            return false;
        }
        for (T checkItem : check) {
            if (!ArrayUtils.contains(array, checkItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable long[] array, long value) {
        if (array == null) {
            return false;
        }
        for (long element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable char[] array, char value) {
        if (array == null) {
            return false;
        }
        for (char element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(@Nullable char[] array, char[] check) {
        if (check == null) {
            return true;
        }
        for (char checkItem : check) {
            if (ArrayUtils.contains(array, checkItem)) continue;
            return false;
        }
        return true;
    }

    public static long total(@Nullable long[] array) {
        long total = 0L;
        if (array != null) {
            for (long value : array) {
                total += value;
            }
        }
        return total;
    }

    public static int[] convertToIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    @Nullable
    public static long[] convertToLongArray(@Nullable int[] intArray) {
        if (intArray == null) {
            return null;
        }
        long[] array = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            array[i] = intArray[i];
        }
        return array;
    }

    @NotNull
    public static <T> T[] appendElement(Class<T> kind, @Nullable T[] array, T element) {
        return ArrayUtils.appendElement(kind, array, element, false);
    }

    @NotNull
    public static <T> T[] appendElement(Class<T> kind, @Nullable T[] array, T element, boolean allowDuplicates) {
        Object[] result;
        int end;
        if (array != null) {
            if (!allowDuplicates && ArrayUtils.contains(array, element)) {
                return array;
            }
            end = array.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    @Nullable
    public static <T> T[] removeElement(Class<T> kind, @Nullable T[] array, T element) {
        if (array != null) {
            if (!ArrayUtils.contains(array, element)) {
                return array;
            }
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (!Objects.equals(array[i], element)) continue;
                if (length == 1) {
                    return null;
                }
                Object[] result = (Object[])Array.newInstance(kind, length - 1);
                System.arraycopy(array, 0, result, 0, i);
                System.arraycopy(array, i + 1, result, i, length - i - 1);
                return result;
            }
        }
        return array;
    }

    @NotNull
    public static int[] appendInt(@Nullable int[] cur, int val, boolean allowDuplicates) {
        if (cur == null) {
            return new int[]{val};
        }
        int N = cur.length;
        if (!allowDuplicates) {
            for (int i = 0; i < N; ++i) {
                if (cur[i] != val) continue;
                return cur;
            }
        }
        int[] ret = new int[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    @NotNull
    public static int[] appendInt(@Nullable int[] cur, int val) {
        return ArrayUtils.appendInt(cur, val, false);
    }

    @Nullable
    public static int[] removeInt(@Nullable int[] cur, int val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            int[] ret = new int[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @Nullable
    public static String[] removeString(@Nullable String[] cur, String val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (!Objects.equals(cur[i], val)) continue;
            String[] ret = new String[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @NotNull
    public static long[] appendLong(@Nullable long[] cur, long val, boolean allowDuplicates) {
        if (cur == null) {
            return new long[]{val};
        }
        int N = cur.length;
        if (!allowDuplicates) {
            for (int i = 0; i < N; ++i) {
                if (cur[i] != val) continue;
                return cur;
            }
        }
        long[] ret = new long[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    @NotNull
    public static long[] appendLong(@Nullable long[] cur, long val) {
        return ArrayUtils.appendLong(cur, val, false);
    }

    @Nullable
    public static long[] removeLong(@Nullable long[] cur, long val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        for (int i = 0; i < N; ++i) {
            if (cur[i] != val) continue;
            long[] ret = new long[N - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N - 1) {
                System.arraycopy(cur, i + 1, ret, i, N - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @Nullable
    public static long[] cloneOrNull(@Nullable long[] array) {
        return array != null ? (long[])array.clone() : null;
    }

    @Nullable
    public static <T> ArraySet<T> cloneOrNull(@Nullable ArraySet<T> array) {
        return array != null ? new ArraySet<T>(array) : null;
    }

    @NotNull
    public static <T> ArraySet<T> add(@Nullable ArraySet<T> cur, T val) {
        if (cur == null) {
            cur = new ArraySet();
        }
        cur.add(val);
        return cur;
    }

    @Nullable
    public static <T> ArraySet<T> remove(@Nullable ArraySet<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    @NotNull
    public static <T> ArrayList<T> add(@Nullable ArrayList<T> cur, T val) {
        if (cur == null) {
            cur = new ArrayList();
        }
        cur.add(val);
        return cur;
    }

    @Nullable
    public static <T> ArrayList<T> remove(@Nullable ArrayList<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    public static <T> boolean contains(@Nullable Collection<T> cur, T val) {
        return cur != null ? cur.contains(val) : false;
    }

    @Nullable
    public static <T> T[] trimToSize(@Nullable T[] array, int size) {
        if (array == null || size == 0) {
            return null;
        }
        if (array.length == size) {
            return array;
        }
        return Arrays.copyOf(array, size);
    }

    public static <T> boolean referenceEquals(ArrayList<T> a, ArrayList<T> b) {
        if (a == b) {
            return true;
        }
        int sizeA = a.size();
        int sizeB = b.size();
        if (a == null || b == null || sizeA != sizeB) {
            return false;
        }
        boolean diff = false;
        for (int i = 0; i < sizeA && !diff; diff |= a.get(i) != b.get(i), ++i) {
        }
        return !diff;
    }

    public static <T> int unstableRemoveIf(@Nullable ArrayList<T> collection, @NotNull Predicate<T> predicate) {
        if (collection == null) {
            return 0;
        }
        int size = collection.size();
        int leftIdx = 0;
        for (int rightIdx = size - 1; leftIdx <= rightIdx; ++leftIdx, --rightIdx) {
            while (leftIdx < size && !predicate.test(collection.get(leftIdx))) {
                ++leftIdx;
            }
            while (rightIdx > leftIdx && predicate.test(collection.get(rightIdx))) {
                --rightIdx;
            }
            if (leftIdx >= rightIdx) break;
            Collections.swap(collection, leftIdx, rightIdx);
        }
        for (int i = size - 1; i >= leftIdx; --i) {
            collection.remove(i);
        }
        return size - leftIdx;
    }

    @NotNull
    public static int[] defeatNullable(@Nullable int[] val) {
        return val != null ? val : EmptyArray.INT;
    }

    @NotNull
    public static String[] defeatNullable(@Nullable String[] val) {
        return val != null ? val : EmptyArray.STRING;
    }
}

