/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.ContextFormat;
import org.beetl.core.Format;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;

public class FormatExpression
extends Expression {
    protected String name;
    protected String pattern;

    public FormatExpression(String name, String pattern, GrammarToken token) {
        super(token);
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public Object evaluate(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public Object evaluateValue(Object o, Context ctx) {
        Format format = null;
        if (this.name != null) {
            format = ctx.gt.getFormat(this.name);
        } else {
            if (o == null) {
                return null;
            }
            format = ctx.gt.getDefaultFormat(o.getClass());
        }
        if (format == null) {
            throw new BeetlException("FORMAT_NOT_FOUND").pushToken(this.token);
        }
        try {
            return format instanceof ContextFormat ? ((ContextFormat)format).format(o, this.pattern, ctx) : format.format(o, this.pattern);
        }
        catch (Exception e) {
            throw new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u683c\u5f0f\u5316\u51fd\u6570\u629b\u51fa\u5f02\u5e38", e).pushToken(this.token);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

