/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.FormatExpression;
import org.beetl.core.statement.FunctionExpression;
import org.beetl.core.statement.PlaceholderST;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;
import org.beetl.sql.core.JavaType;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.engine.SQLVarRef;
import org.beetl.sql.core.kit.StringKit;

public class SQLPlaceholderST
extends Statement {
    public Expression expression;
    public Type type = null;
    FormatExpression format;
    public static final Set<String> textFunList = new HashSet<String>();

    public SQLPlaceholderST(PlaceholderST st) {
        super(st.token);
        this.type = st.type;
        this.expression = st.expression;
        this.format = st.getFormat();
    }

    public final void execute(Context ctx) {
        try {
            Object value = this.expression.evaluate(ctx);
            int jdbcType = 0;
            if (this.format != null) {
                String formatName = this.format.token.text;
                if (formatName.startsWith("typeof")) {
                    String str = formatName.substring(6).toLowerCase();
                    Integer expectJdbcType = JavaType.jdbcTypeNames.get(str = StringKit.toLowerCaseFirstOne(str));
                    if (expectJdbcType == null) {
                        BeetlException be = new BeetlException("FORMAT_NOT_FOUND", formatName + "\u662f\u7528\u6765\u6307\u793ajdbc\u7c7b\u578b\uff0c\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5java.sql.Type");
                        be.pushToken(this.format.token);
                        throw be;
                    }
                    jdbcType = expectJdbcType;
                } else if (formatName.equals("jdbc")) {
                    Integer expectJdbcType = (Integer)this.format.evaluateValue(value, ctx);
                    if (expectJdbcType == null) {
                        BeetlException be = new BeetlException("ERROR", formatName + "\u662f\u7528\u6765\u6307\u793ajdbc\u7c7b\u578b\uff0c\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5java.sql.Type");
                        be.pushToken(this.format.token);
                        throw be;
                    }
                    jdbcType = expectJdbcType;
                } else {
                    value = this.format.evaluateValue(value, ctx);
                }
            }
            if (this.expression instanceof FunctionExpression) {
                FunctionExpression fun = (FunctionExpression)this.expression;
                String funName = fun.token.text;
                if (funName.startsWith("db")) {
                    ctx.byteWriter.writeString(value != null ? value.toString() : "");
                    return;
                }
                if (textFunList.contains(funName)) {
                    ctx.byteWriter.writeString(value != null ? value.toString() : "");
                    return;
                }
            }
            int type = 2;
            if (this.expression instanceof SQLVarRef) {
                type = 1;
            }
            ctx.byteWriter.writeString("?");
            List list = (List)ctx.getGlobal("_paras");
            SQLParameter sqlPara = new SQLParameter(this.expression.token.text, value, type);
            sqlPara.setJdbcType(jdbcType);
            list.add(sqlPara);
        }
        catch (IOException e) {
            BeetlException be = new BeetlException("CLIENT_IO_ERROR_ERROR", e.getMessage(), (Throwable)e);
            be.pushToken(this.token);
            throw be;
        }
    }

    public void infer(InferContext inferCtx) {
        this.expression.infer(inferCtx);
        this.type = this.expression.type;
    }

    static {
        textFunList.add("text");
        textFunList.add("use");
        textFunList.add("globalUse");
        textFunList.add("join");
        textFunList.add("page");
        textFunList.add("orm.single");
        textFunList.add("orm.many");
    }
}

