/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.JavaType;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.annotatoin.ColumnIgnore;
import org.beetl.sql.core.annotatoin.InsertIgnore;
import org.beetl.sql.core.annotatoin.UpdateIgnore;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;

public class ClassDesc {
    Class c;
    TableDesc table;
    NameConversion nc;
    Set<String> propertys = new CaseInsensitiveOrderSet();
    Set<String> dateTypes = new CaseInsensitiveOrderSet();
    Set<String> cols = new CaseInsensitiveOrderSet();
    List<String> idProperties = new ArrayList<String>(3);
    List<String> idCols = new ArrayList<String>(3);
    Map<String, ColumnIgnoreStatus> attrIgnores = new HashMap<String, ColumnIgnoreStatus>();
    Map<String, Object> idMethods = new CaseInsensitiveHashMap();
    String ormQuery = null;

    public ClassDesc(Class c, TableDesc table, NameConversion nc) {
        PropertyDescriptor[] ps;
        this.c = c;
        try {
            ps = BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        Set<String> ids = table.getIdNames();
        CaseInsensitiveHashMap tempMap = new CaseInsensitiveHashMap();
        for (PropertyDescriptor p : ps) {
            String property;
            String col;
            if (p.getReadMethod() == null || p.getWriteMethod() == null || (col = nc.getColName(c, property = p.getName())) == null) continue;
            tempMap.put(col, (Object)p);
        }
        for (String col : table.getCols()) {
            if (!tempMap.containsKey(col)) continue;
            this.cols.add(col);
            PropertyDescriptor p = (PropertyDescriptor)tempMap.get(col);
            this.propertys.add(p.getName());
            Method readMethod = p.getReadMethod();
            ColumnIgnore sqlIgnore = readMethod.getAnnotation(ColumnIgnore.class);
            if (sqlIgnore != null) {
                this.attrIgnores.put(p.getName(), new ColumnIgnoreStatus(sqlIgnore));
            } else {
                InsertIgnore ig = readMethod.getAnnotation(InsertIgnore.class);
                UpdateIgnore ug = readMethod.getAnnotation(UpdateIgnore.class);
                if (ig != null || ug != null) {
                    this.attrIgnores.put(p.getName(), new ColumnIgnoreStatus(ig, ug));
                }
            }
            if (!ids.contains(col)) continue;
            this.idProperties.add(p.getName());
            this.idCols.add(col);
            Class<?> retType = readMethod.getReturnType();
            this.idMethods.put(p.getName(), readMethod);
            if (!Date.class.isAssignableFrom(retType) && !Calendar.class.isAssignableFrom(retType)) continue;
            this.dateTypes.add(p.getName());
        }
    }

    public ClassDesc(TableDesc table, NameConversion nc) {
        this.table = table;
        this.nc = nc;
        for (String colName : table.getCols()) {
            String prop = nc.getPropertyName(colName);
            this.propertys.add(prop);
            ColDesc colDes = table.getColDesc(colName);
            if (JavaType.isDateType(colDes.sqlType)) {
                this.dateTypes.add(prop);
            }
            this.cols.add(colName);
        }
        for (String name : table.getIdNames()) {
            this.idProperties.add(nc.getPropertyName(name));
        }
    }

    public List<String> getIdAttrs() {
        return this.idProperties;
    }

    public List<String> getIdCols() {
        return this.idCols;
    }

    public Set<String> getAttrs() {
        return this.propertys;
    }

    public boolean isDateType(String property) {
        return this.dateTypes.contains(property);
    }

    public Set<String> getInCols() {
        return this.cols;
    }

    public Map<String, Object> getIdMethods() {
        return this.idMethods;
    }

    public boolean isInsertIgnore(String attrName) {
        ColumnIgnoreStatus ignore = this.attrIgnores.get(attrName);
        if (ignore == null) {
            return false;
        }
        return ignore.insertIgnore;
    }

    public boolean isUpdateIgnore(String attrName) {
        ColumnIgnoreStatus ignore = this.attrIgnores.get(attrName);
        if (ignore == null) {
            return false;
        }
        return ignore.updateIgnore;
    }

    static class ColumnIgnoreStatus {
        public boolean insertIgnore;
        public boolean updateIgnore;

        public ColumnIgnoreStatus(ColumnIgnore ignore) {
            this.insertIgnore = ignore.insert();
            this.updateIgnore = ignore.update();
        }

        public ColumnIgnoreStatus(InsertIgnore ig, UpdateIgnore ug) {
            this.insertIgnore = ig != null;
            this.updateIgnore = ug != null;
        }
    }
}

