/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.KeyWordHandler;

public class SqlServerStyle
extends AbstractDBStyle {
    public SqlServerStyle() {
        this.keyWordHandler = new KeyWordHandler(){

            @Override
            public String getTable(String tableName) {
                return "[" + tableName + "]";
            }

            @Override
            public String getCol(String colName) {
                return "[" + colName + "]";
            }
        };
    }

    @Override
    public String getPageSQL(String sql) {
        return "with query as ( select inner_query.*, row_number() over (order by current_timestamp) as beetl_rn from ( " + sql.replaceFirst("(?i)select", "select top(" + this.HOLDER_START + "_pageEnd" + this.HOLDER_END + ") ") + this.getOrderBy() + " ) inner_query ) select * from query where beetl_rn between " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END + " and " + this.HOLDER_START + "_pageEnd" + this.HOLDER_END;
    }

    @Override
    public void initPagePara(Map<String, Object> paras, long start, long size) {
        long s = start + (long)(this.offsetStartZero ? 1 : 0);
        paras.put("_pageOffset", s);
        paras.put("_pageEnd", s + size - 1L);
    }

    @Override
    public String getName() {
        return "sqlserver";
    }

    @Override
    public final int getDBType() {
        return 4;
    }
}

