/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.engine.Pageable;
import org.beetl.sql.core.kit.PageKit;
import org.beetl.sql.core.mapper.BaseMapperInvoke;
import org.beetl.sql.core.mapper.MethodDesc;

public class PageableMapperInvoke
extends BaseMapperInvoke {
    @Override
    public Object call(SQLManager sm, Class entityClass, String sqlId, Method m, Object[] args) {
        if (!Pageable.class.isAssignableFrom(m.getReturnType())) {
            throw new UnsupportedOperationException(m.getName() + " \u65b9\u6cd5\u8fd4\u56de\u503c\u5fc5\u987b\u662f\u5206\u9875\u63a5\u53e3\u7c7b\u578b!");
        }
        Map sqlArgs = this.getSqlArgs(sm, entityClass, m, args, sqlId);
        MethodDesc desc = MethodDesc.getMetodDesc(sm, entityClass, m, sqlId);
        return this.getPage(sm, sqlId, desc.renturnType, sqlArgs);
    }

    protected <T> Pageable<T> getPage(SQLManager sm, String sqlId, Class<T> clazz, Map<String, Object> paras) {
        List list;
        SQLScript sqlScrip = sm.getScript(sqlId);
        String sqlCount = PageKit.getCountSql(sqlScrip.getSql());
        List<Long> countResultList = sm.execute(sqlCount, Long.class, paras);
        int pageNumber = PageKit.getPageNumber(paras);
        int pageSize = PageKit.getPageSize(paras);
        long totalRow = countResultList.get(0);
        Pageable page = PageKit.createPage();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalRow((int)totalRow);
        if (totalRow != 0L) {
            boolean offsetStartZero = sm.isOffsetStartZero();
            long start = (offsetStartZero ? 0 : 1) + (pageNumber - 1) * pageSize;
            long size = pageSize;
            list = sm.select(sqlId, clazz, paras, start, size);
            int totalPage = (int)(totalRow / (long)pageSize);
            if (totalRow % (long)pageSize != 0L) {
                ++totalPage;
            }
            page.setTotalPage(totalPage);
        } else {
            list = Collections.emptyList();
        }
        page.setList(list);
        return page;
    }
}

