/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.engine.Pageable;
import org.beetl.sql.core.kit.PageKit;
import org.beetl.sql.core.mapper.BaseMapperInvoke;
import org.beetl.sql.core.mapper.MethodDesc;

public class SQLReadyExecuteMapperInvoke
extends BaseMapperInvoke {
    int type;

    public SQLReadyExecuteMapperInvoke(int type) {
        this.type = type;
    }

    @Override
    public Object call(SQLManager sm, Class entityClass, String sqlId, Method m, Object[] args) {
        if (this.type == 2 || this.type == 3) {
            MethodDesc desc = MethodDesc.getMetodDesc(sm, entityClass, m, sqlId);
            Class returnType = desc.renturnType;
            List list = sm.execute(new SQLReady(sqlId, args), returnType);
            if (this.type == 2) {
                return list.size() == 0 ? null : list.get(0);
            }
            return list;
        }
        if (this.type == 7) {
            return this.getPage(sm, sqlId, entityClass, args);
        }
        return sm.executeUpdate(new SQLReady(sqlId, args));
    }

    protected <T> Pageable<T> getPage(SQLManager sm, String sql, Class<T> clazz, Object[] args) {
        List list;
        String sqlCount = PageKit.getCountSql(sql);
        Object[] conditionArgs = null;
        if (args.length > 2) {
            conditionArgs = new Object[args.length - 2];
            for (int i = 0; i < conditionArgs.length; ++i) {
                conditionArgs[i] = args[i + 2];
            }
        }
        List<Long> countResultList = sm.execute(new SQLReady(sqlCount, conditionArgs), Long.class);
        int pageNumber = (Integer)args[0];
        int pageSize = (Integer)args[1];
        long totalRow = countResultList.get(0);
        Pageable page = PageKit.createPage();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalRow((int)totalRow);
        if (totalRow != 0L) {
            long start = (sm.isOffsetStartZero() ? 0 : 1) + (pageNumber - 1) * pageSize;
            long size = pageSize;
            String pageSql = sm.getDbStyle().getPageSQLStatement(sql, start, size);
            SQLReady sqlReady = new SQLReady(pageSql, conditionArgs);
            list = sm.execute(sqlReady, clazz);
            int totalPage = (int)(totalRow / (long)pageSize);
            if (totalRow % (long)pageSize != 0L) {
                ++totalPage;
            }
            page.setTotalPage(totalPage);
        } else {
            list = Collections.emptyList();
        }
        page.setList(list);
        return page;
    }
}

