/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.client;

import com.cognos.org.apache.axis.EngineConfiguration;
import com.cognos.org.apache.axis.client.Service;
import com.cognos.org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import com.cognos.org.apache.axis.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class ServiceFactory
extends javax.xml.rpc.ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    private static EngineConfiguration _defaultEngineConfig = null;
    private static ThreadLocal threadDefaultConfig = new ThreadLocal();

    public static void setThreadDefaultConfig(EngineConfiguration config) {
        threadDefaultConfig.set(config);
    }

    private static EngineConfiguration getDefaultEngineConfig() {
        if (_defaultEngineConfig == null) {
            _defaultEngineConfig = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        return _defaultEngineConfig;
    }

    public static Service getService(Map environment) {
        Service service = null;
        InitialContext context = null;
        EngineConfiguration configProvider = (EngineConfiguration)environment.get("engineConfig");
        if (configProvider == null) {
            configProvider = (EngineConfiguration)threadDefaultConfig.get();
        }
        if (configProvider == null) {
            configProvider = ServiceFactory.getDefaultEngineConfig();
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (context != null) {
            String name = (String)environment.get("jndiName");
            if (name == null) {
                name = "axisServiceName";
            }
            try {
                service = (Service)context.lookup(name);
            }
            catch (NamingException e) {
                service = new Service(configProvider);
                try {
                    context.bind(name, (Object)service);
                }
                catch (NamingException e1) {}
            }
        } else {
            service = new Service(configProvider);
        }
        return service;
    }

    public Object getObjectInstance(Object refObject, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object instance = null;
        if (refObject instanceof Reference) {
            Reference ref = (Reference)refObject;
            RefAddr addr = ref.get(SERVICE_CLASSNAME);
            Object obj = null;
            if (addr != null && (obj = addr.getContent()) instanceof String) {
                instance = ClassUtils.forName((String)obj).newInstance();
            } else {
                addr = ref.get(WSDL_LOCATION);
                if (addr != null && (obj = addr.getContent()) instanceof String) {
                    URL wsdlLocation = new URL((String)obj);
                    addr = ref.get(SERVICE_NAMESPACE);
                    if (addr != null && (obj = addr.getContent()) instanceof String) {
                        String namespace = (String)obj;
                        addr = ref.get(SERVICE_LOCAL_PART);
                        if (addr != null && (obj = addr.getContent()) instanceof String) {
                            String localPart = (String)obj;
                            QName serviceName = new QName(namespace, localPart);
                            Class[] formalArgs = new Class[]{URL.class, QName.class};
                            Object[] actualArgs = new Object[]{wsdlLocation, serviceName};
                            Constructor ctor = Service.class.getDeclaredConstructor(formalArgs);
                            instance = ctor.newInstance(actualArgs);
                        }
                    }
                }
            }
            addr = ref.get(MAINTAIN_SESSION);
            if (addr != null && instance instanceof Service) {
                ((Service)instance).setMaintainSession(true);
            }
        }
        return instance;
    }

    public javax.xml.rpc.Service createService(URL wsdlDocumentLocation, QName serviceName) throws ServiceException {
        return new Service(wsdlDocumentLocation, serviceName);
    }

    public javax.xml.rpc.Service createService(QName serviceName) throws ServiceException {
        return new Service(serviceName);
    }
}

